package net.sf.jkniv.sqlegance.builder.xml.dynamic;

public class OtherwiseTag extends WhenTag {

    public static final String TAG_NAME = "otherwise";

    /**
     * Parses the given OGNL expression that can be used by Ognl static methods.
     * 
     * @param ognlExpression
     *            the OGNL expression to be parsed
     * @exception MalformedExpression
     *                if the expression is malformed or if there is a
     *                pathological environmental problem.
     */
    public OtherwiseTag(String text){
		super("true = true", text);
	}

    /**
     * This node always return true.
     * @return return true always.
     */
	@Override
	public boolean eval(Object rootObjects) {
		return true;
	}
}
