/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml.dynamic;

/**
 * The text from node elements at XML file.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public interface ITextTag
{
    /**
     * Evaluate if attribute test is true or false with OGNL expression.
     * Something
     * 
     * @param rootObjects
     *            the root object for the OGNL expression.
     * @return true at expression is true, false otherwise.
     * @throws MalformedExpression
     *             if the expression is malformed.
     * @see ognl.Ognl
     */
    boolean eval(Object rootObjects);
    
    /**
     * Retrieve the text from XML element, can be dynamic or static.
     * 
     * @return
     */
    String getText();
    
    /**
     * Indicate if text is dynamic or static.
     * 
     * @return true returned if dynamic, false otherwise.
     */
    boolean isDynamic();
}
