/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml.dynamic;

import java.math.BigDecimal;

import ognl.Ognl;
import ognl.OgnlException;

/**
 * Evaluate with ONGL expression.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
final class ExpressionEvaluator
{
    private ExpressionEvaluator()
    {
        // hidden constructor form utility classes
    }
    
    /**
     * Evaluates the given OGNL expression tree to extract a value from the
     * given root object.
     * 
     * @param expression
     *            the OGNL expression tree to evaluate, as returned by
     *            parseExpression()
     * @param parameterObject
     *            the root object for the OGNL expression
     * @return the result of evaluating the expression true or false.
     * @exception MalformedExpression
     *                if the expression called a method which failed or if the
     *                expression referred to a nonexistent property
     */
    static boolean eval(Object expression, Object parameterObject)
    {
        boolean result = false;
        if (expression != null)
        {
            try
            {
                Object value = Ognl.getValue(expression, parameterObject);
                if (value instanceof Boolean)
                    result = (Boolean) value;
                else if (value instanceof Number)
                    result = !new BigDecimal(String.valueOf(value)).equals(BigDecimal.ZERO);
                // else
                // result = value != null;
            }
            catch (OgnlException e)
            {
                throw new MalformedExpression("Error evaluating expression '" + expression + "'. Cause: " + e, e);
            }
        }
        return result;
    }
}
