package net.sf.jkniv.sqlegance.builder.xml.dynamic;

import java.util.List;

public class ChooseTag implements ITextTag
{
    public static final String TAG_NAME = "choose";
    private List<WhenTag>     listWhenTag;
    private String text;
    
    /**
     * Build a new <code>choose</code> tag.
     * 
     * @param listIfTag
     *            list of texts from <code>when</code> tags
     */
    public ChooseTag(List<WhenTag> listWhenTag)
    {
    	this.text = "";
        this.listWhenTag = listWhenTag;
    }
    
    /**
     * Evaluate if attribute test is true from <code>when</code> list tags, the first option is selected.
     * 
     * @return true if some test case its true, false otherwise. If have an <code>otherwise</code> always true is returned.
     */
    public boolean eval(Object rootObjects)
    {
        boolean evaluation = false;
        for (int i = 0; i < listWhenTag.size(); i++)
        {
            ITextTag tag = listWhenTag.get(i);
            if (tag.eval(rootObjects))
            {
                evaluation = true;
                this.text = tag.getText();
                break;
            }
        }
        return evaluation;
    }
    
    /**
     * Retrieve the dynamic text from XML element.
     * 
     * @return text from XML element.
     */
    public String getText()
    {
    	return this.text;
    }
    
    /**
     * Indicate if text is dynamic or static.
     * 
     * @return always true is returned, because this object save dynamic text.
     */
    public boolean isDynamic()
    {
        return true;
    }

}
