/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml;

/**
 * Tag of procedure sentence. <b>Stored procedures don't work yet!</b>
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public class ProcedureTag extends AbstractSqlTag implements ISqlTag
{
    public static final String      TAG_NAME         = "procedure";
    public static final String      ATTRIBUTE_SPNAME = "spname";
    
    /**
     * Name of stored procedure at database
     */
    private String                  spName;
    
    /**
     * Parameters from stored procedure. The parameters are at the order from
     * signature of procedure.
     */
    private ProcedureParameterTag[] params;
    
    /**
     * Build a new <code>procedure</code> tag from XML file.
     * 
     * @param id
     *            Name/Identify from tag.
     * @param languageType
     *            type of language from tag.
     */
    public ProcedureTag(String id, LanguageType lanaguageType)
    {
        super(id, lanaguageType);
        // this.spName = spName;
    }
    
    /**
     * Retrieve the tag name.
     * 
     * @return name from tag <code>procedure</code>.
     */
    public String getTagName()
    {
        return TAG_NAME;
    }
    
    /**
     * Command type to execute.
     * 
     * @return the type of command used, <code>DELETE</code>.
     */
    public SqlCommandType getSqlCommandType()
    {
        return SqlCommandType.PROCEDURE;
    }
    
    /**
     * Define parameters from stored procedure
     * 
     * @param params
     *            the parameters
     */
    public void setParams(ProcedureParameterTag[] params)
    {
        this.params = params;
    }
    
    /**
     * Retrieve parameter from stored procedure
     * 
     * @return the parameters
     */
    public ProcedureParameterTag[] getParams()
    {
        return params;
    }
    
    /**
     * Define the name of stored procedure.
     * 
     * @param spName
     *            name of stored procedure.
     */
    public void setSpName(String spName)
    {
        this.spName = spName;
    }
    
    /**
     * Retrieve the name from stored procedure.
     * 
     * @return name of stored procedure
     */
    public String getSpName()
    {
        return spName;
    }
}
