/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml;

/**
 * Tag of include xml file. Include tag is used to organize xml sentences at
 * many files separated.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public class IncludeTag extends AbstractSqlTag implements ISqlTag
{
    public static final String TAG_NAME       = "include";
    public static final String ATTRIBUTE_HREF = "href";
    
    /**
     * Build a new <code>include</code> tag from XML file.
     * 
     * @param id
     *            Name/Identify from tag.
     * @param languageType
     *            type of language from tag.
     */
    public IncludeTag(String id, LanguageType lanaguageType)
    {
        super(id, lanaguageType);
    }
    
    /**
     * @return NULL is returned, because this tag not is SQL sentence.
     */
    public String getSql(Object params)
    {
        // TODO Auto-generated method stub
        return null;
    }
    
    /**
     * Retrieve the tag name.
     * 
     * @return name from tag <code>include</code>.
     */
    public String getTagName()
    {
        return TAG_NAME;
    }
    
    /**
     * Command type to execute.
     * 
     * @return the type of command used, <code>UNKNOW</code>.
     */
    public SqlCommandType getSqlCommandType()
    {
        return SqlCommandType.UNKNOWN;
    }
    
}
