/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml;

import java.util.List;

import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;

/**
 * Represent specifics attribute from tag to build SQL sentences from XML files.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public interface ISqlTag extends ISql
{
    /**
     * Retrieve the identifier from tag.
     * 
     * @return name from tag
     */
    String getName();
    
    /**
     * Retrieve the tag name.
     * 
     * @return name from tag.
     */
    String getTagName();
    
    /**
     * add a set of static text from tag elements.
     */
    void addTag(String text);
    
    /**
     * add a new text tag.
     */
    void addTag(ITextTag tag);
    
    /**
     * add a set of text tags (static or dynamic).
     */
    void addTag(List<ITextTag> tags);
}
