/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml;

/**
 * This class represent a query language (JPQL, HQL or SQL) from XML file, each
 * node at xml file is represented by this class. Those queries can be dynamic
 * or static and to recover a dynamic query (built on-the-fly) is necessary to
 * pass the parameters that can be mounted.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public interface ISql
{
    /**
     * Retrieve static sql from a node, the dynamic parts is skipped.
     * 
     * @return Sql sentence
     */
    String getSql();
    
    /**
     * Retrieve dynamic sql from a node, the dynamic parts is evaluated at time
     * to create the sql.
     * 
     * @param params
     *            parameters to evaluate dynamic sql, can be a object like
     *            Author, Book, etc or a java.util.Map where yours keys is like
     *            the properties.
     * @return Dynamic sql sentence
     */
    String getSql(Object params);
    
    /**
     * Retrieve node type: INSERT, UPDATE, DELETE, SELECT or PROCEDURE.
     * 
     * @return node type declared at xml file.
     */
    SqlCommandType getSqlCommandType();
    
    /**
     * Retrieve the language type used at sql sentence.
     * 
     * @return language type declared at xml file.
     */
    LanguageType getLanguageType();
}
