package net.sf.jkniv.sqlegance.builder;

import java.util.HashMap;
import java.util.Map;

import net.sf.jkniv.sqlegance.builder.xml.ISql;

class SqlPackage 
{
	private String packet;
	private Map<String, ISql> map = new HashMap<String, ISql>();
    private static final Map<String, SqlPackage> container = new HashMap<String, SqlPackage>();

	
	private SqlPackage(String packet) 
	{
	    this.packet = packet;
	    this.map = new HashMap<String, ISql>();
	}

	public void addSql(String name, String tagName, String fileName, ISql tag)
    {
        if (map.containsKey(name))
            throw new IllegalArgumentException("package ["+packet+"] Query with name <" + tagName + " name=\"" + name + "\"... is duplicated at file [" + fileName + "]");
        
        map.put(name, tag);
    }

    /**
     * Retrieve one query according your name.
     * 
     * @param name
     *            Name of the query.
     * @return Return the query object with SQL.
     * @exception IllegalArgumentException
     *                if the parameter name does not refer names of query
     *                configured this exception is throwed.
     */
    public ISql getQuery(String name)
    {
        ISql sql = null;
        if (!map.containsKey(name))
            throw new IllegalArgumentException("Query not found [" + name + "]");
        
        sql = map.get(name);
        
        return sql;
    }

    public boolean containsQuery(String name)
    {
        return map.containsKey(name);
    }
    
    private static void clear() 
    {
        container.clear();
    }
    
    private static String getPackageName(String name)
    {
        return null;
    }

    private static String getQueryName(String name)
    {
        return null;
    }

}
