/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder;

import net.sf.jkniv.sqlegance.builder.xml.XMLFileStatus;

/**
 * Represent each XML file declared at SqlConfig.xml or your include files.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public class SqlFile
{
    private String        name;
    private XMLFileStatus status;
    
    /**
     * Build a new sql file with <code>UNPROCESSED</code> status.
     * 
     * @param name
     *            XML relative name
     */
    public SqlFile(String name)
    {
        this.name = name;
        this.status = XMLFileStatus.UNPROCESSED;
    }
    
    /**
     * Retrieve the XML relative name.
     * 
     * @return relative name of XML file.
     */
    public String getName()
    {
        return name;
    }
    
    /**
     * Status from XML file.
     * 
     * @return <code>UNPROCESSED</code> or <code>PROCESSED</code>
     */
    public XMLFileStatus getStatus()
    {
        return status;
    }
    
    /**
     * put the status of file as <code>PROCESSED</code>
     */
    public void processed()
    {
        this.status = XMLFileStatus.PROCESSED;
    }
    
    @Override
    public String toString()
    {
        return name + ": " + status;
    }
}
