/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance;

/**
 * @author alisson gomes
 * @since 0.0.2
 */
public class Query implements IQuery
{
    private String  name;
    private Integer start;
    private Integer max;
    private Long    total;
    private Object  params;
    
    /**
     * TODO documentation
     * 
     * @param name
     * @param params
     * @param start
     * @param max
     */
    public Query(String name, Object params, int start, int max)
    {
        this.name = name;
        this.params = params;
        this.start = start;
        this.max = max;
        this.total = -1L;
    }
    
    /**
     * TODO documentation
     * 
     * @param name
     * @param params
     */
    public Query(String name, Object params)
    {
        this(name, params, 0, Integer.MAX_VALUE);
    }
    
    /**
     * TODO documentation
     * 
     * @param name
     */
    public Query(String name)
    {
        this(name, null, 0, Integer.MAX_VALUE);
    }
    
    public String getName()
    {
        return name;
    }
    
    public Object getParams()
    {
        return this.params;
    }
    
    public int getStart()
    {
        return this.start;
    }
    
    /**
     * @param value
     */
    public void setStart(int value)
    {
        this.start = value;
        
    }
    
    public int getMax()
    {
        return this.max;
    }
    
    public void setMax(int value)
    {
        this.max = value;
    }
    
    public Long getTotal()
    {
        return this.total;
    }
    
    public void setTotal(Long total)
    {
        this.total = total;
    }
    
    @Override
    public String toString()
    {
        return "name=" + this.name + ", start=" + this.start + ", max=" + this.max + ", total=" + this.total;
    }
}
