/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance;

/**
 * <p>
 * A set of rules for determining the query name to a set of methods (get, list,
 * add, remove, update) from IRepository that don't have a query object as
 * parameter. To change the strategy implements this interface and configure at
 * persistence.xml one property called whinstone.repository.sqlnamestrategy.
 * </p>
 * <p>
 * Sample:
 * 
 * <pre>
 *   &lt;properties&gt;
 *     &lt;property name="jkniv.repository.namestrategy" value="com.acme.MyDefualtSqlNameStrategy" /&gt;
 *   &lt;/properties&gt;
 * </pre>
 * 
 * </p>
 * 
 * @author Alisson Gomes
 */
public interface ISqlNameStrategy
{
    static String PROPERTY_NAME_STRATEGY = "jkniv.repository.namestrategy";
    
    /**
     * Return the default query name at XML file to retrieve an object by 'get'
     * method.
     * 
     * @param o
     *            instance of object that will be persisted
     * @return name of query method
     */
    String toGetName(Object o);
    
    /**
     * Return the default query name at XML file to retrieve an object by 'add'
     * method.
     * 
     * @param o
     *            instance of object that will be persisted
     * @return name of query method
     */
    String toAddName(Object o);
    
    /**
     * Return the default query name at XML file to retrieve an object by
     * 'remove' method.
     * 
     * @param o
     *            instance of object that will be persisted
     * @return name of query method
     */
    String toRemoveName(Object o);
    
    /**
     * Return the default query name at XML file to retrieve an object by
     * 'update' method.
     * 
     * @param o
     *            instance of object that will be persisted
     * @return name of query method
     */
    String toUpdateName(Object o);
    
    /**
     * Return the default query name at XML file to retrieve an object by 'list'
     * method.
     * 
     * @param o
     *            instance of object that will be persisted
     * @return name of query method
     */
    String toListName(Object o);
}
