/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance;

/**
 * This class represent a query object to find the query to be performed and
 * your parameters like: query parameters, offset and max objects to return.
 * 
 * @author alisson gomes
 * @since 0.0.2
 */
public interface IQuery
{
    /**
     * The query name used to localize the query at in XML file.
     * 
     * @return Return the name of the query.
     */
    String getName();
    
    /**
     * Parameters of query. Can be objects like Author, Book, etc. or a
     * java.util.Map.
     * 
     * @return the parameters to use at query.
     */
    Object getParams();
    
    /**
     * Get the number from first row from query result. If not set, rows will be
     * retrieved beginning from row 0.
     * 
     * @return return a row number, numbered from 0.
     */
    int getStart();
    
    /**
     * Set the number from first row from query result. If not set, rows will be
     * retrieved beginning from row 0.
     * 
     * @param value
     */
    void setStart(int value);
    
    /**
     * Get the maximum number of rows from query result.
     * 
     * @return Return the maximum number.
     */
    int getMax();
    
    /**
     * Set the maximum number of rows from query result.
     * 
     * @param value
     */
    void setMax(int value);
    
    /**
     * Get total of rows that query can retrieve, filled after query is
     * executed. Useful to make pagination.
     * 
     * @return return the number of rows from query result.
     */
    Long getTotal();
}
