/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance;

public class DefaultSqlNameStrategy implements ISqlNameStrategy
{
    public String toGetName(Object o)
    {
        return o.getClass().getSimpleName() + ".get";
    }
    
    public String toAddName(Object o)
    {
        return o.getClass().getSimpleName() + ".add";
    }
    
    public String toRemoveName(Object o)
    {
        return o.getClass().getSimpleName() + ".remove";
    }
    
    public String toUpdateName(Object o)
    {
        return o.getClass().getSimpleName() + ".update";
    }
    
    public String toListName(Object o)
    {
        return o.getClass().getSimpleName() + ".list";
    }
}
