/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import net.sf.jkniv.whinstone.types.ColumnType;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.JdbcType;

public class EnumOrdinalType
implements Convertible<Enum<?>, Integer> {
    private Class<?> enumType;

    public EnumOrdinalType(Class<?> enumType) {
        this.enumType = enumType;
    }

    @Override
    public Integer toJdbc(Enum<?> attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute.ordinal();
    }

    @Override
    public Enum<?> toAttribute(Integer jdbc) {
        if (jdbc == null) {
            return null;
        }
        return (Enum)this.enumType.getEnumConstants()[jdbc];
    }

    @Override
    public Class getType() {
        return this.enumType;
    }

    @Override
    public ColumnType getColumnType() {
        return JdbcType.INTEGER;
    }

    public String toString() {
        return "EnumOrdinalType [enumType=" + this.enumType + ", type=" + this.getType() + ", columnType=" + this.getColumnType() + "]";
    }
}

