/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.sf.jkniv.sqlegance.RepositoryConfigException;
import net.sf.jkniv.sqlegance.RepositoryType;
import net.sf.jkniv.whinstone.spi.RepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryService {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryService.class);
    private static RepositoryService service;
    private ServiceLoader<RepositoryFactory> loader = ServiceLoader.load(RepositoryFactory.class);

    private RepositoryService() {
    }

    public static synchronized RepositoryService getInstance() {
        if (service == null) {
            service = new RepositoryService();
        }
        return service;
    }

    public RepositoryFactory lookup(RepositoryType type) {
        return this.lookup(type.name());
    }

    public RepositoryFactory lookup(String type) {
        RepositoryFactory factory = null;
        try {
            Iterator<RepositoryFactory> factories = this.loader.iterator();
            while (factory == null && factories.hasNext()) {
                RepositoryFactory f = factories.next();
                if (f == null || !type.equals(f.getType().name())) continue;
                factory = f;
            }
        }
        catch (ServiceConfigurationError serviceError) {
            LOG.error("Unexpected error", (Throwable)serviceError);
            factory = null;
        }
        if (factory == null) {
            throw new RepositoryConfigException("RepositoryFactory for [" + type + "] type cannot be found, verify if jar file from repository it's set in classpath");
        }
        return factory;
    }
}

