/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.whinstone.Filter;
import net.sf.jkniv.whinstone.QueryName;
import net.sf.jkniv.whinstone.Queryable;
import net.sf.jkniv.whinstone.types.RegisterType;

public class QueryFactory {
    private static final Assertable NOT_NULL = AssertsFactory.getNotNull();

    QueryFactory() {
    }

    public static Queryable of(String name, Object ... params) {
        NOT_NULL.verify(new Object[]{name});
        return QueryFactory.buildQueryable(name, 0, Integer.MAX_VALUE, null, params);
    }

    public static Queryable of(String name, RegisterType registerType, Object ... args) {
        NOT_NULL.verify(new Object[]{name, registerType});
        return QueryFactory.buildQueryable(name, 0, Integer.MAX_VALUE, registerType, args);
    }

    public static Queryable of(String name, Object params) {
        NOT_NULL.verify(new Object[]{name, params});
        return new QueryName(name, params, 0, Integer.MAX_VALUE);
    }

    public static Queryable ofArray(String name, Object ... params) {
        NOT_NULL.verify(new Object[]{name, params});
        return new QueryName(name, params, 0, Integer.MAX_VALUE);
    }

    public static Queryable ofArray(String name, RegisterType registerType, Object ... params) {
        NOT_NULL.verify(new Object[]{name, registerType, params});
        return new QueryName(name, params, 0, Integer.MAX_VALUE, registerType);
    }

    public static Queryable of(String name, Object params, int offset, int max) {
        NOT_NULL.verify(new Object[]{name, name, params});
        return new QueryName(name, params, offset, max);
    }

    public static Queryable of(String name, int offset, int max) {
        NOT_NULL.verify(new Object[]{name});
        return new QueryName(name, null, offset, max);
    }

    public static <T> Queryable of(String name, Class<T> returnType, Object ... args) {
        NOT_NULL.verify(new Object[]{name, returnType, args});
        QueryName q = (QueryName)QueryFactory.buildQueryable(name, 0, Integer.MAX_VALUE, null, args);
        q.setReturnType(returnType);
        return q;
    }

    public static <T> Queryable of(String name, Class<T> returnType, Object params) {
        NOT_NULL.verify(new Object[]{name, returnType, params});
        QueryName q = new QueryName(name, params);
        q.setReturnType(returnType);
        return q;
    }

    public static <T> Queryable of(String name, Class<T> returnType) {
        NOT_NULL.verify(new Object[]{name, returnType});
        QueryName q = new QueryName(name);
        q.setReturnType(returnType);
        return q;
    }

    public static <T> Queryable clone(Queryable queryable) {
        NOT_NULL.verify(new Object[]{queryable});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), queryable.getRegisterType(), null);
    }

    public static <T> Queryable clone(Queryable queryable, Class<T> returnType) {
        NOT_NULL.verify(new Object[]{queryable, returnType});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), queryable.getRegisterType(), returnType);
    }

    public static <T> Queryable clone(Queryable queryable, RegisterType registerType) {
        NOT_NULL.verify(new Object[]{queryable, registerType});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), registerType, null);
    }

    public static <T> Queryable clone(Queryable queryable, RegisterType registerType, Class<T> returnType) {
        NOT_NULL.verify(new Object[]{queryable, registerType});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), registerType, returnType);
    }

    public static <T> Queryable clone(String queryName, Queryable queryable, Object params, RegisterType registerType, Class<T> returnType) {
        QueryName q = new QueryName(queryName, params, queryable.getOffset(), queryable.getMax(), registerType);
        if (returnType != null) {
            q.setReturnType(returnType);
        } else if (queryable.hasReturnType()) {
            q.setReturnType(queryable.getReturnType());
        }
        if (queryable.isCacheIgnore()) {
            q.cacheIgnore();
        }
        if (queryable.isScalar()) {
            q.scalar();
        }
        q.setSorter(queryable.getSorter());
        q.setFilter(queryable.getFilter());
        q.setBookmark(queryable.getBookmark());
        return q;
    }

    private static Queryable buildQueryable(String name, int offset, int max, RegisterType registerType, Object ... args) {
        Map<String, Object> params;
        NOT_NULL.verify(args);
        QueryName queryable = null;
        queryable = args.length == 1 ? new QueryName(name, args[0], offset, max, registerType) : ((params = QueryFactory.buildParams(args)).size() > 0 ? new QueryName(name, params, offset, max, registerType) : new QueryName(name, null, offset, max, registerType));
        return queryable;
    }

    static Map<String, Object> buildParams(Object ... args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int i = 0;
        Object value = null;
        String key = null;
        for (Object o : args) {
            if (i % 2 == 0) {
                key = o.toString();
            } else {
                value = o;
                params.put(key, value);
                key = null;
                value = null;
            }
            ++i;
        }
        return params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, Object> mapParams = new HashMap<String, Object>();
        private Object[] arrayOfParams;
        private Object params;
        private int offset;
        private int max = Integer.MAX_VALUE;
        private boolean scalar = false;
        private RegisterType registerType;
        private Class<?> returnType;
        private Comparator<?> sorter;
        private Filter<?> filter;

        public Queryable build(String name) {
            QueryName q = null;
            q = this.arrayOfParams != null ? new QueryName(name, this.arrayOfParams, this.offset, this.max, this.registerType) : (this.params != null ? new QueryName(name, this.params, this.offset, this.max, this.registerType) : (!this.mapParams.isEmpty() ? new QueryName(name, this.mapParams, this.offset, this.max, this.registerType) : new QueryName(name, null, this.offset, this.max, this.registerType)));
            q.setReturnType(this.returnType);
            q.setSorter(this.sorter);
            q.setFilter(this.filter);
            if (this.scalar) {
                q.scalar();
            }
            return q;
        }

        public Builder params(Object ... params) {
            this.mapParams = QueryFactory.buildParams(params);
            return this;
        }

        public Builder params(String name, Object value) {
            this.mapParams.put(name, value);
            return this;
        }

        public <T> Builder params(T param) {
            this.params = param;
            return this;
        }

        public Builder ofArray(Object ... params) {
            this.arrayOfParams = params;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder max(int max) {
            this.max = max;
            return this;
        }

        public Builder registerType(RegisterType registerType) {
            this.registerType = registerType;
            return this;
        }

        public Builder returnType(Class<?> returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder sorter(Comparator<?> sorter) {
            this.sorter = sorter;
            return this;
        }

        public Builder filter(Filter<?> filter) {
            this.filter = filter;
            return this;
        }

        public Builder scalar() {
            this.scalar = true;
            return this;
        }
    }
}

