/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone;

import java.util.Collection;

public class Param {
    private static final int NO_INDEX = -1;
    private Object value;
    private Object valueAs;
    private int index = -1;
    private String name;

    public Param() {
    }

    public Param(Object value) {
        this(value, value, "?", -1);
    }

    public Param(Object value, int index) {
        this(value, value, "?", index);
    }

    public Param(Object value, String name) {
        this(value, value, name, -1);
    }

    public Param(Object value, Object valueAs, String name) {
        this(value, valueAs, name, -1);
    }

    public Param(Object value, String name, int index) {
        this(value, value, name, index);
    }

    public Param(Object value, Object valueAs, String name, int index) {
        this();
        this.value = value;
        this.valueAs = valueAs;
        this.index = index;
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueAs() {
        return this.valueAs;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int index) {
        if (this.index == -1) {
            this.index = index;
        }
    }

    public Param[] asArray() {
        Param[] params = null;
        if (this.isArray()) {
            params = this.ofArray();
        } else if (this.isCollection()) {
            params = this.ofCollection();
        } else {
            throw new IllegalStateException("Cannot retrieve the parameter as array because is not a collection or array");
        }
        return params;
    }

    public boolean isArray() {
        return this.value != null && this.value.getClass().isArray();
    }

    public boolean isCollection() {
        return this.value instanceof Collection;
    }

    private Param[] ofCollection() {
        Collection paramsAsCollection = (Collection)this.value;
        Param[] params = new Param[paramsAsCollection.size()];
        int i = 0;
        for (Object o : paramsAsCollection) {
            params[i] = new Param(o, this.name, i);
            ++i;
        }
        return params;
    }

    private Param[] ofArray() {
        Object[] paramsAsArray = (Object[])this.value;
        Param[] params = new Param[paramsAsArray.length];
        int i = 0;
        for (Object o : paramsAsArray) {
            params[i] = new Param(o, this.name, i);
            ++i;
        }
        return params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Param other = (Param)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "Param [value=" + this.value + ", index=" + this.index + ", name=" + this.name + "]";
    }
}

