/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.reflect.beans.ObjectProxyFactory;
import net.sf.jkniv.reflect.beans.PropertyAccess;
import net.sf.jkniv.whinstone.JdbcColumn;
import net.sf.jkniv.whinstone.types.Converter;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.EnumNameType;
import net.sf.jkniv.whinstone.types.EnumOrdinalType;
import net.sf.jkniv.whinstone.types.NoConverterType;
import net.sf.jkniv.whinstone.types.TypeMap;
import net.sf.jkniv.whinstone.types.UnknowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterType {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterType.class);
    private final Map<TypeMap, Convertible<Object, Object>> registry = new HashMap<TypeMap, Convertible<Object, Object>>();

    public void register(Convertible convertible) {
        TypeMap typeMapByClass;
        LOG.info("Registering converter {} {}", (Object)convertible);
        Convertible<Object, Object> c = this.registry.put(new TypeMap(convertible.getType(), convertible.getColumnType()), convertible);
        if (c != null && c != convertible) {
            LOG.warn("The converter {} was replaced by {}", c, (Object)convertible);
        }
        if ((c = this.registry.put(typeMapByClass = new TypeMap(convertible.getType(), UnknowType.getInstance()), convertible)) != null && c != convertible) {
            LOG.warn("Default converter for {} was replaced by {}", c, (Object)convertible);
        }
    }

    public <T> Convertible<Object, Object> toJdbc(PropertyAccess access, ObjectProxy<T> proxy) {
        Convertible<Object, Object> convertible = this.getConverterByAnnotation(access.getField(), access.getReadMethod(), proxy);
        if (convertible == null) {
            if (access.hasField()) {
                convertible = this.registry.get(new TypeMap(access.getField().getType(), UnknowType.getInstance()));
            }
            if (convertible == null) {
                convertible = NoConverterType.getInstance();
            }
        }
        return convertible;
    }

    public Convertible<Object, Object> getConverter(Class classType) {
        Convertible<Object, Object> convertible = this.registry.get(new TypeMap(classType, UnknowType.getInstance()));
        if (convertible == null) {
            convertible = NoConverterType.getInstance();
        }
        return convertible;
    }

    public <T, R> Convertible<Object, Object> toAttribute(JdbcColumn<R> column, ObjectProxy<T> proxy) {
        PropertyAccess access = column.getPropertyAccess();
        Convertible<Object, Object> convertible = this.getConverterByAnnotation(access.getField(), access.getWriterMethod(), proxy);
        if (convertible == null) {
            if (column.getPropertyAccess().hasField()) {
                convertible = this.registry.get(new TypeMap(column.getPropertyAccess().getField().getType(), column.getType()));
            } else if (column.getPropertyAccess().hasWriterMethod()) {
                convertible = this.registry.get(new TypeMap(column.getPropertyAccess().getWriterMethod().getParameterTypes()[0], column.getType()));
            }
            if (convertible == null) {
                convertible = NoConverterType.getInstance();
            }
        }
        return convertible;
    }

    private <T> Convertible<Object, Object> getConverterByAnnotation(Field field, Method method, ObjectProxy<T> proxy) {
        Convertible<Enum<?>, String> convertible = null;
        Converter converter = null;
        if (field == null || method == null || Map.class.isAssignableFrom(proxy.getTargetClass()) || Collection.class.isAssignableFrom(proxy.getTargetClass()) || proxy.getTargetClass().isArray()) {
            return convertible;
        }
        converter = method.getAnnotation(Converter.class);
        if (converter == null) {
            converter = field.getAnnotation(Converter.class);
        }
        if (converter != null) {
            ObjectProxy proxyConvertible = null;
            if (converter.converter().isEnum()) {
                convertible = converter.isEnum() == Converter.EnumType.ORDINAL ? new EnumOrdinalType(converter.converter()) : new EnumNameType(converter.converter());
            } else {
                proxyConvertible = ObjectProxyFactory.of((Class)converter.converter());
                if (converter.pattern() != null) {
                    proxyConvertible.setConstructorArgs(new Object[]{converter.pattern()});
                }
                convertible = (Convertible)proxyConvertible.newInstance();
            }
        } else if (field.getType().isEnum()) {
            convertible = new EnumNameType(field.getType());
        }
        return convertible;
    }

    public boolean isEmpty() {
        return this.registry.isEmpty();
    }
}

