/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import net.sf.jkniv.whinstone.types.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JdbcType implements ColumnType
{
    BIT(-7),
    TINYINT(-6),
    SMALLINT(5),
    INTEGER(4),
    BIGINT(-5),
    FLOAT(6),
    REAL(7),
    DOUBLE(8),
    NUMERIC(2),
    DECIMAL(3),
    CHAR(1),
    VARCHAR(12),
    LONGVARCHAR(-1),
    DATE(91),
    TIME(92),
    TIMESTAMP(93),
    BINARY(-2),
    VARBINARY(-3),
    LONGVARBINARY(-4),
    NULL(0),
    OTHER(1111),
    JAVA_OBJECT(2000),
    DISTINCT(2001),
    STRUCT(2002),
    ARRAY(2003),
    BLOB(2004),
    CLOB(2005),
    REF(2006),
    DATALINK(70),
    BOOLEAN(16),
    ROWID(-8),
    NCHAR(-15),
    NVARCHAR(-9),
    LONGNVARCHAR(-1),
    NCLOB(2011),
    SQLXML(2009),
    REF_CURSOR(2012),
    TIME_WITH_TIMEZONE(2013),
    TIMESTAMP_WITH_TIMEZONE(2014);

    private static final Logger LOG;
    private int value;

    private JdbcType(int v) {
        this.value = v;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean isBinary() {
        return this.value == 2005 || this.value == 2004;
    }

    @Override
    public boolean isBlob() {
        return this.value == 2004;
    }

    @Override
    public boolean isClob() {
        return this.value == 2005;
    }

    @Override
    public boolean isDate() {
        return this.value == 91;
    }

    @Override
    public boolean isTimestamp() {
        return this.value == 93;
    }

    @Override
    public boolean isTime() {
        return this.value == 92;
    }

    public static ColumnType valueOf(int jdbcTypeValue) {
        JdbcType answer = null;
        for (JdbcType jdbcType : JdbcType.values()) {
            if (jdbcType.value() != jdbcTypeValue) continue;
            answer = jdbcType;
            break;
        }
        return answer;
    }

    static {
        LOG = LoggerFactory.getLogger(JdbcType.class);
    }
}

