/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.statement;

import java.sql.SQLException;
import net.sf.jkniv.reflect.Injectable;
import net.sf.jkniv.reflect.InjectableFactory;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.sqlegance.logger.DataMasking;
import net.sf.jkniv.whinstone.JdbcColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultRow {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResultRow.class);
    private final Logger sqlLog;
    private final DataMasking masking;

    public AbstractResultRow(Logger log, DataMasking masking) {
        this.sqlLog = log;
        this.masking = masking;
    }

    public <R> Object getValueOf(JdbcColumn<R> column, R rs) throws SQLException {
        return column.isBinary() ? column.getBytes(rs) : column.getValue(rs);
    }

    public <T, R> void setValueOf(ObjectProxy<T> proxy, JdbcColumn<R> column, R rs) throws SQLException {
        Injectable reflect = InjectableFactory.of(proxy);
        Object jdbcObject = this.getValueOf(column, rs);
        if (this.sqlLog.isTraceEnabled()) {
            this.sqlLog.trace("Mapping index [{}] column [{}] type of [{}] to value [{}]", new Object[]{column.getIndex(), column.getAttributeName(), jdbcObject != null ? jdbcObject.getClass().getName() : "null", this.masking.mask(column.getAttributeName(), jdbcObject)});
        }
        if (column.isNestedAttribute()) {
            reflect.inject(column.getAttributeName(), jdbcObject);
        } else {
            String method = column.getMethodName();
            if (proxy.hasMethod(method)) {
                reflect.inject(method, jdbcObject);
            } else {
                LOG.warn("Method [{}] doesn't exists for [{}] to set value [{}]", new Object[]{method, proxy.getTargetClass().getName(), jdbcObject});
            }
        }
    }
}

