/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.params;

import net.sf.jkniv.whinstone.Param;
import net.sf.jkniv.whinstone.Queryable;
import net.sf.jkniv.whinstone.params.AbstractParam;
import net.sf.jkniv.whinstone.params.AutoBindParams;
import net.sf.jkniv.whinstone.statement.StatementAdapter;

class NamedParams
extends AbstractParam
implements AutoBindParams {
    private StatementAdapter<?, ?> stmtAdapter;
    private Queryable queryable;
    private String[] paramsNames;

    public NamedParams(StatementAdapter<?, ?> stmtAdapter, Queryable queryable) {
        this.stmtAdapter = stmtAdapter;
        this.queryable = queryable;
        this.paramsNames = queryable.getParamsNames();
    }

    @Override
    public void on() {
        this.checkIfAllParamenterValuesIsHere();
        for (String s : this.paramsNames) {
            if (this.hasInClause(s)) {
                Param[] params = null;
                String paramName = s.substring(3, s.length());
                Param param = this.queryable.getProperty(paramName);
                if (param.isCollection() || param.isArray()) {
                    params = param.asArray();
                }
                this.stmtAdapter.bind(params);
                continue;
            }
            Param p = this.queryable.getProperty(s);
            this.stmtAdapter.bind(p);
        }
    }

    private void checkIfAllParamenterValuesIsHere() {
        this.queryable.values();
    }

    @Override
    public int onBulk() {
        this.on();
        return this.stmtAdapter.execute();
    }
}

