/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.commands;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jkniv.cache.Cacheable;
import net.sf.jkniv.sqlegance.LanguageType;
import net.sf.jkniv.sqlegance.RepositoryException;
import net.sf.jkniv.sqlegance.Selectable;
import net.sf.jkniv.sqlegance.Sql;
import net.sf.jkniv.sqlegance.builder.xml.SqlTag;
import net.sf.jkniv.sqlegance.builder.xml.TagFactory;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureSupport;
import net.sf.jkniv.whinstone.Param;
import net.sf.jkniv.whinstone.QueryFactory;
import net.sf.jkniv.whinstone.Queryable;
import net.sf.jkniv.whinstone.commands.Command;
import net.sf.jkniv.whinstone.commands.CommandAdapter;
import net.sf.jkniv.whinstone.commands.DefaultCommandHandler;

public abstract class DefaultQueryHandler
extends DefaultCommandHandler {
    public DefaultQueryHandler(CommandAdapter cmdAdapter) {
        super(cmdAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run() {
        this.checkSqlConstraints();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing [{}] as {} command", (Object)this.queryable, (Object)this.sql.getSqlType());
        }
        List list = Collections.emptyList();
        this.sql.getValidateType().assertValidate(this.queryable.getParams());
        Selectable selectable = this.sql.asSelectable();
        if (!this.queryable.isBoundSql()) {
            this.queryable.bind((Sql)selectable);
        }
        Cacheable.Entry entry = null;
        if (!this.queryable.isCacheIgnore()) {
            entry = selectable.getCache().getEntry((Object)this.queryable);
        }
        try {
            if (entry == null) {
                try {
                    this.preCallback();
                    Command command = this.asCommand();
                    list = (List)command.execute();
                    if (this.queryable.hasFilter()) {
                        this.filtering(list);
                    }
                    if (this.queryable.hasSorter()) {
                        Collections.sort(list, this.queryable.getSorter());
                    }
                    this.postCallback();
                    if (selectable.hasCache() && !list.isEmpty()) {
                        selectable.getCache().put((Object)this.queryable, (Object)list);
                    }
                    this.paging(list);
                }
                catch (Exception e) {
                    this.queryable.setTotal(-3L);
                    this.postException();
                    this.handleableException.handle(e);
                }
            } else {
                this.queryable.cached();
                this.queryable.setTotal(-2L);
                list = (List)entry.getValue();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} object(s) was returned from [{}] cache using query [{}] since {} reach [{}] times", new Object[]{list.size(), selectable.getCache().getName(), this.sql.getName(), entry.getTimestamp(), entry.hits()});
                }
            }
        }
        finally {
            this.cmdAdapter.close();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executed [{}] query as {} command, {} rows fetched", new Object[]{this.queryable.getName(), this.sql.getSqlType(), list.size()});
        }
        return (T)list;
    }

    private void filtering(List<?> list) {
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            if (this.queryable.getFilter().isEqual(it.next())) continue;
            it.remove();
        }
    }

    private void paging(List<?> list) {
        block8: {
            if (this.queryable.isPaging()) {
                Sql dynamicSql = this.queryable.getDynamicSql();
                if (dynamicSql.getSqlDialect().supportsFeature(SqlFeatureSupport.PAGING_ROUNDTRIP)) {
                    try {
                        Command command = this.cmdAdapter.asSelectCommand(this.createQueryableForPaging(), null);
                        List rows = (List)command.execute();
                        if (rows.isEmpty()) {
                            this.queryable.setTotal(0L);
                            break block8;
                        }
                        this.queryable.setTotal(((Number)rows.get(0)).longValue());
                    }
                    catch (RepositoryException e) {
                        this.queryable.setTotal(-2L);
                        LOG.error("Could not count the total of rows from full query [{}]", (Object)this.queryable.getName(), (Object)e);
                    }
                } else {
                    this.queryable.setTotal(-2L);
                }
            } else if (this.queryable.getTotal() < 0L) {
                this.queryable.setTotal(list.size());
            }
        }
    }

    private Queryable createQueryableForPaging() {
        String queryName = "#paging_" + System.currentTimeMillis() + "_for_" + this.queryable.getName();
        Param[] paramValues = this.queryable.values();
        Object[] paramArray = new Object[paramValues.length];
        for (int i = 0; i < paramValues.length; ++i) {
            paramArray[i] = paramValues[i].getValue();
        }
        Queryable paging = QueryFactory.ofArray(queryName, this.queryable.getRegisterType(), paramArray);
        Selectable selectable = TagFactory.newSelect((String)queryName, (LanguageType)LanguageType.NATIVE, (SqlDialect)this.queryable.getDynamicSql().getSqlDialect());
        if (selectable instanceof SqlTag) {
            SqlTag sqlTag = (SqlTag)selectable;
            sqlTag.addTag(this.queryable.queryCount());
            paging.bind((Sql)selectable);
        }
        paging.scalar();
        return paging;
    }

    private void checkSqlConstraints() {
        Selectable selectable = this.sql.asSelectable();
        LanguageType type = selectable.getLanguageType();
        if ((type == LanguageType.JPQL || type == LanguageType.HQL) && selectable.getGroupBy().trim().length() > 0) {
            throw new IllegalArgumentException("JPQL cannot have group by, just NATIVE or STORED, change the type [" + type + "] from SQL [" + selectable.getName() + "] to execute");
        }
    }
}

