/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.commands;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.exception.HandleableException;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.reflect.beans.ObjectProxyFactory;
import net.sf.jkniv.sqlegance.Sql;
import net.sf.jkniv.sqlegance.SqlType;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureSupport;
import net.sf.jkniv.whinstone.Queryable;
import net.sf.jkniv.whinstone.ResultRow;
import net.sf.jkniv.whinstone.commands.CallbackProcessor;
import net.sf.jkniv.whinstone.commands.Command;
import net.sf.jkniv.whinstone.commands.CommandAdapter;
import net.sf.jkniv.whinstone.commands.CommandHandler;
import net.sf.jkniv.whinstone.commands.ObjectCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultCommandHandler
implements CommandHandler {
    static final Logger LOG = LoggerFactory.getLogger(DefaultCommandHandler.class);
    static final Assertable NOT_NULL = AssertsFactory.getNotNull();
    private static final Map<String, ObjectCallback> OBJECTS_CALLBACKS = new HashMap<String, ObjectCallback>();
    CommandAdapter cmdAdapter;
    Command command;
    ObjectProxy<?> proxyParams;
    protected Queryable queryable;
    protected Sql sql;
    protected ResultRow<?, ?> overloadResultRow;
    protected HandleableException handleableException;

    public DefaultCommandHandler(CommandAdapter cmdAdapter) {
        this.cmdAdapter = cmdAdapter;
    }

    @Override
    public CommandHandler with(ResultRow<?, ?> overloadResultRow) {
        this.overloadResultRow = overloadResultRow;
        return this;
    }

    @Override
    public CommandHandler with(Queryable queryable) {
        this.queryable = queryable;
        if (queryable.getParams() != null) {
            this.proxyParams = ObjectProxyFactory.of(queryable.getParams());
            CallbackProcessor processor = new CallbackProcessor(this.proxyParams);
            if (!OBJECTS_CALLBACKS.containsKey(this.proxyParams.getTargetClass().getName())) {
                ObjectCallback objectCallback = processor.loadCallbackEvents();
                OBJECTS_CALLBACKS.put(this.proxyParams.getTargetClass().getName(), objectCallback);
            }
        }
        return this;
    }

    @Override
    public CommandHandler with(Sql sql) {
        this.sql = sql;
        return this;
    }

    @Override
    public CommandHandler with(HandleableException handlerException) {
        this.handleableException = handlerException;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run() {
        NOT_NULL.verify(new Object[]{this.cmdAdapter, this.queryable, this.sql});
        T t = null;
        Number rows = 0;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing [{}] as {} command", (Object)this.queryable, (Object)this.sql.getSqlType());
        }
        try {
            if (!this.queryable.isBoundSql()) {
                this.queryable.bind(this.sql);
            }
            try {
                this.preCallback();
                this.sql.getValidateType().assertValidate(this.queryable.getParams());
                this.command = this.asCommand();
                t = this.command.execute();
                if (t instanceof Number) {
                    rows = (Number)t;
                }
                if (this.queryable.getDynamicSql().getSqlDialect().supportsFeature(SqlFeatureSupport.PAGING_ROUNDTRIP)) {
                    this.queryable.setTotal(rows.longValue());
                } else {
                    this.queryable.setTotal(-2L);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} records was affected by {} [{}] query", new Object[]{rows, this.sql.getSqlType(), this.queryable.getName()});
                }
                this.postCallback();
            }
            catch (Exception e) {
                this.queryable.setTotal(-3L);
                this.postException();
                this.handleableException.handle(e);
            }
        }
        finally {
            this.cmdAdapter.close();
        }
        return t;
    }

    protected CommandAdapter getCommandAdapter() {
        return this.cmdAdapter;
    }

    @Override
    public CommandHandler preCallback() {
        ObjectCallback objectCallback;
        if (this.proxyParams != null && (objectCallback = OBJECTS_CALLBACKS.get(this.proxyParams.getTargetClass().getName())) != null) {
            Set<Method> methods = objectCallback.getPreMethods(this.sql.getSqlType());
            for (Method m : methods) {
                this.proxyParams.invoke(m, new Object[0]);
            }
        }
        return this;
    }

    @Override
    public CommandHandler postCallback() {
        ObjectCallback objectCallback;
        if (this.proxyParams != null && (objectCallback = OBJECTS_CALLBACKS.get(this.proxyParams.getTargetClass().getName())) != null) {
            Set<Method> methods = objectCallback.getPostMethods(this.sql.getSqlType());
            for (Method m : methods) {
                this.proxyParams.invoke(m, new Object[0]);
            }
        }
        return this;
    }

    @Override
    public CommandHandler postCommit() {
        return this;
    }

    @Override
    public CommandHandler postException() {
        return this;
    }

    @Override
    public CommandHandler checkSqlType(SqlType expected) {
        if (this.sql == null) {
            throw new IllegalArgumentException("Null Sql reference wasn't expected");
        }
        if (this.sql.getSqlType() != expected) {
            throw new IllegalArgumentException("Cannot execute sql [" + this.sql.getName() + "] as " + this.sql.getSqlType() + ", " + expected + " was expect");
        }
        return this;
    }
}

