/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.reflect.BasicType;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.reflect.beans.ObjectProxyFactory;
import net.sf.jkniv.reflect.beans.PropertyAccess;
import net.sf.jkniv.sqlegance.Sql;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureSupport;
import net.sf.jkniv.sqlegance.params.ParamMarkType;
import net.sf.jkniv.sqlegance.params.ParamParser;
import net.sf.jkniv.sqlegance.transaction.Isolation;
import net.sf.jkniv.whinstone.ArrayIterator;
import net.sf.jkniv.whinstone.Filter;
import net.sf.jkniv.whinstone.Param;
import net.sf.jkniv.whinstone.Queryable;
import net.sf.jkniv.whinstone.params.AutoBindParams;
import net.sf.jkniv.whinstone.params.ParameterException;
import net.sf.jkniv.whinstone.params.ParameterNotFoundException;
import net.sf.jkniv.whinstone.params.PrepareParamsFactory;
import net.sf.jkniv.whinstone.statement.StatementAdapter;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.NoConverterType;
import net.sf.jkniv.whinstone.types.RegisterType;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryName
implements Queryable {
    private static final Logger LOG = LoggerFactory.getLogger(QueryName.class);
    private static final Assertable NOT_NULL = AssertsFactory.getNotNull();
    private static final Assertable IS_NULL = AssertsFactory.getIsNull();
    private static final BasicType BASIC_TYPE = BasicType.getInstance();
    private static final RegisterType NO_REGISTRY = new RegisterType();
    private String name;
    private Integer offset;
    private Integer max;
    private Long total;
    private Isolation isolation;
    private String hint;
    private int timeout;
    private boolean batch;
    private final Object params;
    private boolean scalar;
    private int size;
    private TYPEOF_PARAM paramType;
    private Class<?> returnType;
    private Sql sql;
    protected String sqlText;
    protected String sqlTextPaginated;
    protected String sqlTextToCount;
    protected String[] paramsNames;
    protected int countParams;
    private String bookmark;
    private boolean boundSql;
    private boolean boundParams;
    private boolean cached;
    private boolean cacheIgnore;
    private final RegisterType registerType;
    private Comparator<?> sorter;
    private Filter<?> filter;

    public QueryName(String name, Object params) {
        this(name, params, 0, Integer.MAX_VALUE);
    }

    public QueryName(String name) {
        this(name, null, 0, Integer.MAX_VALUE);
    }

    public QueryName(String name, Object params, int offset, int max) {
        this(name, params, offset, max, new RegisterType());
    }

    public QueryName(String name, Object params, int offset, int max, RegisterType registerType) {
        this.name = name;
        this.params = params;
        this.offset = offset;
        this.max = max;
        this.total = -1L;
        this.isolation = Isolation.DEFAULT;
        this.timeout = -1;
        this.hint = "";
        this.batch = false;
        this.boundSql = false;
        this.boundParams = false;
        this.cached = false;
        this.cacheIgnore = false;
        this.registerType = registerType != null ? registerType : NO_REGISTRY;
        this.sizeOfParams();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T getParams() {
        return (T)this.params;
    }

    @Override
    public Param getProperty(String name) {
        Param param = null;
        if (!this.isTypeOfNull()) {
            try {
                Object o = PropertyUtils.getProperty((Object)this.params, (String)name);
                param = new Param(o, this.getConverter(name, o).toJdbc(o), name);
            }
            catch (Exception e) {
                throw new ParameterNotFoundException("Cannot find the property [" + name + "] at param object [" + (this.params != null ? this.params.getClass().getName() : "null") + "] ", e);
            }
        }
        return param;
    }

    @Override
    public Param getProperty(String name, int index) {
        Param param = null;
        if (!this.isTypeOfNull()) {
            try {
                Object o = PropertyUtils.getProperty((Object)this.params, (String)name);
                param = new Param(o, this.getConverter(name, o).toJdbc(o), name, index);
            }
            catch (Exception e) {
                throw new ParameterNotFoundException("Cannot find the property [" + name + "] at param object [" + (this.params != null ? this.params.getClass().getName() : "null") + "] ", e);
            }
        }
        return param;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int value) {
        this.offset = value;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMax(int value) {
        this.max = value;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public boolean hasRowsOffset() {
        return this.offset > 0;
    }

    @Override
    public boolean isPaging() {
        return this.max < Integer.MAX_VALUE;
    }

    @Override
    public void scalar() {
        this.scalar = true;
    }

    @Override
    public boolean isScalar() {
        return this.scalar;
    }

    @Override
    public boolean isBoundSql() {
        return this.boundSql;
    }

    @Override
    public boolean isBoundParams() {
        return this.boundParams;
    }

    @Override
    public boolean isTypeOfNull() {
        return this.params == null;
    }

    @Override
    public boolean isTypeOfBasic() {
        return this.paramType == TYPEOF_PARAM.BASIC;
    }

    @Override
    public boolean isTypeOfPojo() {
        return this.paramType == TYPEOF_PARAM.POJO;
    }

    @Override
    public boolean isTypeOfArrayBasicTypes() {
        return this.paramType == TYPEOF_PARAM.ARRAY_BASIC;
    }

    @Override
    public boolean isTypeOfArrayPojo() {
        return this.paramType == TYPEOF_PARAM.ARRAY_POJO;
    }

    @Override
    public boolean isTypeOfArrayMap() {
        return this.paramType == TYPEOF_PARAM.ARRAY_MAP;
    }

    @Override
    public boolean isTypeOfCollectionBasicTypes() {
        return this.paramType == TYPEOF_PARAM.LIST_BASIC || this.paramType == TYPEOF_PARAM.COLLECTION_BASIC;
    }

    private boolean isTypeOfListBasicTypes() {
        return this.paramType == TYPEOF_PARAM.LIST_BASIC;
    }

    @Override
    public boolean isTypeOfCollectionPojo() {
        return this.paramType == TYPEOF_PARAM.COLLECTION_POJO;
    }

    @Override
    public boolean isTypeOfCollectionMap() {
        return this.paramType == TYPEOF_PARAM.COLLECTION_MAP;
    }

    @Override
    public boolean isTypeOfCollectionArray() {
        return this.paramType == TYPEOF_PARAM.COLLECTION_ARRAY;
    }

    @Override
    public boolean isTypeOfArray() {
        return this.paramType == TYPEOF_PARAM.ARRAY_BASIC || this.paramType == TYPEOF_PARAM.ARRAY_POJO || this.paramType == TYPEOF_PARAM.ARRAY_MAP;
    }

    @Override
    public boolean isTypeOfCollection() {
        return this.paramType == TYPEOF_PARAM.LIST_BASIC || this.paramType == TYPEOF_PARAM.COLLECTION_BASIC || this.paramType == TYPEOF_PARAM.COLLECTION_POJO || this.paramType == TYPEOF_PARAM.COLLECTION_MAP || this.paramType == TYPEOF_PARAM.COLLECTION_ARRAY;
    }

    @Override
    public boolean isTypeOfBulk() {
        return this.paramType == TYPEOF_PARAM.COLLECTION_POJO || this.paramType == TYPEOF_PARAM.COLLECTION_MAP || this.paramType == TYPEOF_PARAM.COLLECTION_ARRAY || this.paramType == TYPEOF_PARAM.ARRAY_MAP || this.paramType == TYPEOF_PARAM.ARRAY_POJO;
    }

    @Override
    public boolean isTypeOfMap() {
        return this.paramType == TYPEOF_PARAM.MAP;
    }

    private void sizeOfParams() {
        this.size = 0;
        if (this.params == null) {
            this.paramType = TYPEOF_PARAM.NULL;
        } else if (BASIC_TYPE.isBasicType(this.params.getClass())) {
            this.size = 1;
            this.paramType = TYPEOF_PARAM.BASIC;
        } else if (Map.class.isInstance(this.params)) {
            this.size = ((Map)this.params).size();
            this.paramType = TYPEOF_PARAM.MAP;
        } else if (this.params.getClass().isArray()) {
            this.size = ((Object[])this.params).length;
            this.checkArrayParams();
        } else if (Collection.class.isInstance(this.params)) {
            this.size = ((Collection)this.params).size();
            this.checkCollectionParams();
        } else {
            this.size = 1;
            this.paramType = TYPEOF_PARAM.POJO;
        }
    }

    private void checkArrayParams() {
        this.paramType = TYPEOF_PARAM.ARRAY_POJO;
        Object param = null;
        if (((Object[])this.params).length > 0) {
            param = ((Object[])this.params)[0];
        }
        if (param != null) {
            if (BASIC_TYPE.isBasicType(param.getClass())) {
                this.paramType = TYPEOF_PARAM.ARRAY_BASIC;
            } else if (param instanceof Map) {
                this.paramType = TYPEOF_PARAM.ARRAY_MAP;
            }
        }
    }

    private void checkCollectionParams() {
        Iterator it = ((Collection)this.params).iterator();
        Object param = null;
        this.paramType = TYPEOF_PARAM.COLLECTION_POJO;
        do {
            if (it.hasNext()) {
                param = it.next();
            }
            if (param == null) continue;
            if (BASIC_TYPE.isBasicType(param.getClass())) {
                this.paramType = this.params instanceof List ? TYPEOF_PARAM.LIST_BASIC : TYPEOF_PARAM.COLLECTION_BASIC;
                continue;
            }
            if (param instanceof Map) {
                this.paramType = TYPEOF_PARAM.COLLECTION_MAP;
                continue;
            }
            if (!param.getClass().isArray()) continue;
            this.paramType = TYPEOF_PARAM.COLLECTION_ARRAY;
        } while (param == null && it.hasNext());
    }

    @Override
    public Iterator<Param> iterator() {
        if (this.params == null) {
            throw new NullPointerException("Cannot iterate over null reference");
        }
        ArrayIterator it = null;
        if (this.params instanceof Map) {
            it = new ArrayIterator((Map)this.params);
        } else if (this.isTypeOfArray()) {
            it = new ArrayIterator((Object[])this.params, this.size);
        } else if (this.isTypeOfCollection()) {
            it = new ArrayIterator((Collection)this.params);
        } else {
            throw new UnsupportedOperationException("Cannot iterate over another type of object, just Arrays or Collections");
        }
        return it;
    }

    @Override
    public Param[] values() {
        ArrayList<Param> paramsValues = new ArrayList<Param>();
        int i = 0;
        if (this.isTypeOfBasic()) {
            paramsValues.add(new Param(this.getConverter("?", this.getParams()).toJdbc(this.getParams()), i));
        } else if (this.isTypeOfBulk()) {
            Iterator<Param> it = this.iterator();
            while (it.hasNext()) {
                paramsValues.add(it.next());
            }
        } else {
            for (String name : this.paramsNames) {
                Param paramValue = null;
                if (this.paramsNames[i].toLowerCase().startsWith("in:")) {
                    String paramName = this.paramsNames[i].substring(3, this.paramsNames[i].length());
                    paramValue = this.size == this.countParams ? new Param(this.params, name, i) : this.getParamsFromIndex(i);
                    if (paramValue == null) {
                        paramValue = this.getProperty(paramName);
                    }
                    Param[] paramsIN = null;
                    paramsIN = paramValue.isCollection() || paramValue.isArray() ? paramValue.asArray() : new Param[]{paramValue};
                    if (paramValue.getValue() == null) {
                        throw new ParameterException("Cannot set parameter [" + this.paramsNames[i] + "] from IN clause with NULL");
                    }
                    for (int j = 0; j < paramsIN.length; ++j) {
                        paramsValues.add(paramsIN[j]);
                    }
                } else if ("?".equals(name)) {
                    if (this.size != this.paramsNames.length && !this.hasInClause(this.paramsNames)) {
                        throw new ParameterException("A query [" + this.name + "] with positional parameters needs an array exactly have the same number of parameters from query.");
                    }
                    paramsValues.add(this.getParamsFromIndex(i));
                } else {
                    paramsValues.add(this.getProperty(name, i));
                }
                ++i;
            }
        }
        return paramsValues.toArray(new Param[0]);
    }

    @Override
    public void bind(Sql sql) {
        IS_NULL.verify((RuntimeException)new IllegalStateException("Cannot re-assign new Sql to queryable [" + this.name + "] object"), new Object[]{this.sql});
        NOT_NULL.verify(new Object[]{sql});
        this.sql = sql;
        this.sqlText = sql.getSql(this.params);
        boolean pagingSelect = false;
        SqlDialect sqlDialect = this.sql.getSqlDialect();
        if (sql.isSelectable() && this.isPaging()) {
            pagingSelect = true;
            this.sqlTextPaginated = sqlDialect.supportsFeature(SqlFeatureSupport.BOOKMARK_QUERY) ? sqlDialect.buildQueryPaging(this.sqlText, this.offset.intValue(), this.max.intValue(), this.bookmark) : sqlDialect.buildQueryPaging(this.sqlText, this.offset.intValue(), this.max.intValue());
        }
        this.replaceForPlaceholder();
        if (pagingSelect && sqlDialect.supportsFeature(SqlFeatureSupport.PAGING_ROUNDTRIP)) {
            this.sqlTextToCount = sqlDialect.buildQueryCount(this.sqlText);
            if (sql.getSqlDialect().supportsFeature(SqlFeatureSupport.LIMIT) && this.sqlTextPaginated == null) {
                throw new IllegalStateException("SqlDialect [" + sql.getSqlDialect().name() + "] supports paging query but the COUNT query cannot be build");
            }
        }
        this.boundSql = true;
    }

    @Override
    public <T, R> AutoBindParams bind(StatementAdapter<T, R> adapter) {
        AutoBindParams prepareParams = null;
        prepareParams = this.isTypeOfNull() || this.paramsNames.length == 0 ? PrepareParamsFactory.newNoParams(adapter) : (this.isTypeOfBasic() || this.params instanceof Date || this.params instanceof Calendar ? PrepareParamsFactory.newBasicParam(adapter, this) : (this.isTypeOfArrayBasicTypes() ? PrepareParamsFactory.newPositionalArrayParams(adapter, this) : (this.isTypeOfArrayMap() || this.isTypeOfCollectionMap() ? PrepareParamsFactory.newPositionalCollectionMapParams(adapter, this) : (this.isTypeOfArrayPojo() || this.isTypeOfCollectionPojo() ? PrepareParamsFactory.newPositionalCollectionPojoParams(adapter, this, this.registerType) : (this.isTypeOfCollectionBasicTypes() ? PrepareParamsFactory.newPositionalCollectionParams(adapter, this) : (this.isTypeOfCollectionArray() ? PrepareParamsFactory.newPositionalCollectionArrayParams(adapter, this) : (this.sql.getParamParser().getType() == ParamMarkType.QUESTION ? PrepareParamsFactory.newPositionalParams(adapter, this) : PrepareParamsFactory.newNamedParams(adapter, this))))))));
        this.boundParams = true;
        return prepareParams;
    }

    @Override
    public String query() {
        if (!this.boundSql) {
            throw new IllegalStateException("Needs to bind Sql before to call Queryable.query");
        }
        return this.sqlTextPaginated == null ? this.sqlText : this.sqlTextPaginated;
    }

    @Override
    public String queryCount() {
        if (!this.boundSql) {
            throw new IllegalStateException("Needs to bind Sql before to call Queryable.queryCount");
        }
        return this.sqlTextToCount;
    }

    @Override
    public String[] getParamsNames() {
        if (!this.boundSql) {
            throw new IllegalStateException("Needs to bind Sql before to call Queryable.getParamsName");
        }
        return this.paramsNames;
    }

    private void replaceForPlaceholder() {
        ParamParser paramParser = this.sql.getParamParser();
        this.paramsNames = paramParser.find(this.sqlText);
        if (this.sqlTextPaginated != null) {
            this.sqlTextPaginated = paramParser.replaceForPlaceholder(this.sqlTextPaginated, this.params);
        }
        this.sqlText = paramParser.replaceForPlaceholder(this.sqlText, this.params);
        this.countParams = this.countOccurrencesOf(this.sqlText, "?");
    }

    private int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    @Override
    public Sql getDynamicSql() {
        return this.sql;
    }

    public Class<?> getReturnType() {
        Class returnAnswer = Map.class;
        if (this.returnType != null) {
            returnAnswer = this.returnType;
        } else if (this.isBoundSql() && this.getDynamicSql().getReturnTypeAsClass() != null) {
            returnAnswer = this.getDynamicSql().getReturnTypeAsClass();
        }
        return returnAnswer;
    }

    @Override
    public boolean hasReturnType() {
        return this.returnType != null;
    }

    void setReturnType(Class<?> clazz) {
        IS_NULL.verify(new Object[]{this.returnType});
        this.returnType = clazz;
    }

    <T> void setSorter(Comparator<T> sorter) {
        this.sorter = sorter;
    }

    <T> void setFilter(Filter<T> filter) {
        this.filter = filter;
    }

    @Override
    public RegisterType getRegisterType() {
        return this.registerType;
    }

    @Override
    public void cacheIgnore() {
        this.cacheIgnore = true;
    }

    @Override
    public boolean isCacheIgnore() {
        return this.cacheIgnore;
    }

    @Override
    public void cached() {
        this.cached = true;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public String getBookmark() {
        return this.bookmark;
    }

    @Override
    public <T> Comparator<T> getSorter() {
        return this.sorter;
    }

    @Override
    public <T> Filter<T> getFilter() {
        return this.filter;
    }

    @Override
    public boolean hasSorter() {
        return this.sorter != null;
    }

    @Override
    public boolean hasFilter() {
        return this.filter != null;
    }

    private Param getParamsFromIndex(int i) {
        Param param = null;
        if (this.params == null) {
            param = new Param();
        } else if (this.isTypeOfArrayBasicTypes()) {
            param = new Param(((Object[])this.params)[i], "?", i);
        } else if (this.isTypeOfListBasicTypes()) {
            param = new Param(((List)this.params).get(i), "?", i);
        } else if (this.isTypeOfCollectionBasicTypes()) {
            Iterator it = ((Collection)this.params).iterator();
            int j = 0;
            while (it.hasNext()) {
                if (j == i) {
                    param = new Param(it.next(), "?", i);
                    break;
                }
                ++j;
            }
        }
        return param;
    }

    private boolean hasInClause(String[] paramsNames) {
        for (String p : paramsNames) {
            if (!this.hasInClause(p)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInClause(String paramName) {
        return paramName.toLowerCase().startsWith("in:");
    }

    private Convertible<Object, Object> getConverter(String fieldName, Object value) {
        Convertible<Object, Object> convertible = NoConverterType.getInstance();
        PropertyAccess propertyAccess = new PropertyAccess(fieldName, this.getParams().getClass());
        if (propertyAccess.hasField() || propertyAccess.hasReadMethod()) {
            ObjectProxy proxy = ObjectProxyFactory.of(this.getParams());
            convertible = this.registerType.toJdbc(propertyAccess, proxy);
        } else if (value != null) {
            convertible = this.registerType.getConverter(value.getClass());
        }
        return convertible;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.getName().hashCode());
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryName other = (QueryName)obj;
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return !(this.sql == null ? other.sql != null : !this.sql.equals(other.sql));
    }

    public String toString() {
        return "QueryName [name=" + this.name + ", offset=" + this.offset + ", max=" + this.max + ", timeout=" + this.timeout + ", batch=" + this.batch + ", scalar=" + this.scalar + ", paramType=" + (Object)((Object)this.paramType) + "]";
    }

    private static enum TYPEOF_PARAM {
        NULL,
        BASIC,
        ARRAY_BASIC,
        ARRAY_POJO,
        ARRAY_MAP,
        COLLECTION_BASIC,
        COLLECTION_POJO,
        COLLECTION_MAP,
        COLLECTION_ARRAY,
        LIST_BASIC,
        MAP,
        POJO;

    }
}

