/* 
 * JKNIV, whinstone one contract to access your database.
 * 
 * Copyright (C) 2017, the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.sf.jkniv.whinstone.types;

import net.sf.jkniv.sqlegance.RepositoryException;

/**
 * 
 * @author Alisson Gomes
 * @since 0.6.0
 */
public class ConverterException extends RepositoryException
{
    private static final long serialVersionUID = 133741996020374064L;

    /**
     * Constructor for ConverterException without message detail
     */
    public ConverterException()
    {
        super();
    }
    
    /**
     * Constructor for ConverterException.
     * @param msg the detail from exception message
     */
    public ConverterException(String msg)
    {
        super(msg);
    }
    
    /**
     * Constructor for ConverterException.
     * @param msg the detail from exception message
     * @param cause the trouble root cause , usually JDBC family exception
     */
    public ConverterException(String msg, Throwable cause)
    {
        super(msg, cause);
    }
    
    public ConverterException(Throwable cause)
    {
        super(cause);
    }
    
}
