/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.sf.jkniv.whinstone.types.ColumnType;
import net.sf.jkniv.whinstone.types.ConverterException;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.JdbcType;

public class CalendarIntType
implements Convertible<Calendar, Integer> {
    private String pattern;

    public CalendarIntType(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Integer toJdbc(Calendar attribute) {
        if (attribute == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
        return Integer.valueOf(sdf.format(attribute.getTime()));
    }

    @Override
    public Calendar toAttribute(Integer jdbc) {
        if (jdbc == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(sdf.parse(String.valueOf(jdbc)));
            return calendar;
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Class<Calendar> getType() {
        return Calendar.class;
    }

    @Override
    public ColumnType getColumnType() {
        return JdbcType.INTEGER;
    }

    public String toString() {
        return "CalendarIntType [pattern=" + this.pattern + ", type=" + this.getType() + ", columnType=" + this.getColumnType() + "]";
    }
}

