/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import net.sf.jkniv.whinstone.types.ColumnType;
import net.sf.jkniv.whinstone.types.ConverterException;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.JdbcType;

public class BooleanIntType
implements Convertible<Boolean, Integer> {
    private int truePattern;
    private int falsePattern;

    public BooleanIntType(String pattern) {
        String[] patterns = pattern.split("\\|");
        if (patterns.length != 2) {
            throw new ConverterException("BooleanIntType expect a separator \"|\" to handle true and false values, for example \"1|0\". The value was: " + pattern);
        }
        this.truePattern = Integer.valueOf(patterns[0]);
        this.falsePattern = Integer.valueOf(patterns[1]);
    }

    @Override
    public Integer toJdbc(Boolean attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute != false ? this.truePattern : this.falsePattern;
    }

    @Override
    public Boolean toAttribute(Integer jdbc) {
        if (jdbc == null) {
            return null;
        }
        return jdbc.equals(this.truePattern) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public ColumnType getColumnType() {
        return JdbcType.INTEGER;
    }

    public String toString() {
        return "BooleanIntType [truePattern=" + this.truePattern + ", falsePattern=" + this.falsePattern + ", type=" + this.getType() + ", columnType=" + this.getColumnType() + "]";
    }
}

