/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.commands;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.sqlegance.SqlType;
import net.sf.jkniv.whinstone.CallbackScope;
import net.sf.jkniv.whinstone.PostCallBack;
import net.sf.jkniv.whinstone.PreCallBack;
import net.sf.jkniv.whinstone.commands.ObjectCallback;

class CallbackProcessor {
    private ObjectProxy<?> proxyParams;

    public CallbackProcessor(ObjectProxy<?> proxyParams) {
        this.proxyParams = proxyParams;
    }

    public ObjectCallback loadCallbackEvents() {
        int n;
        ObjectCallback objectCallback = new ObjectCallback(this.proxyParams.getTargetClass());
        List precallbacks = this.proxyParams.getMethodsAnnotatedWith(PreCallBack.class);
        List postcallbacks = this.proxyParams.getMethodsAnnotatedWith(PostCallBack.class);
        for (Method m : precallbacks) {
            PreCallBack precallback = m.getAnnotation(PreCallBack.class);
            CallbackScope[] callbackScopeArray = precallback.scope();
            n = callbackScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CallbackScope scope = callbackScopeArray[n2];
                if (scope.isSelect()) {
                    objectCallback.addPreMethod(SqlType.SELECT, m);
                } else if (scope.isAdd()) {
                    objectCallback.addPreMethod(SqlType.INSERT, m);
                } else if (scope.isUpdate()) {
                    objectCallback.addPreMethod(SqlType.UPDATE, m);
                } else if (scope.isRemove()) {
                    objectCallback.addPreMethod(SqlType.DELETE, m);
                }
                ++n2;
            }
        }
        for (Method m : postcallbacks) {
            PostCallBack postcallback = m.getAnnotation(PostCallBack.class);
            List<CallbackScope> scopes = Arrays.asList(postcallback.scope());
            CallbackScope[] callbackScopeArray = postcallback.scope();
            int n3 = callbackScopeArray.length;
            n = 0;
            while (n < n3) {
                CallbackScope scope = callbackScopeArray[n];
                if (scope.isSelect()) {
                    objectCallback.addPostMethod(SqlType.SELECT, m);
                } else if (scope.isAdd()) {
                    objectCallback.addPostMethod(SqlType.INSERT, m);
                } else if (scope.isUpdate()) {
                    objectCallback.addPostMethod(SqlType.UPDATE, m);
                } else if (scope.isRemove()) {
                    objectCallback.addPostMethod(SqlType.DELETE, m);
                }
                ++n;
            }
        }
        return objectCallback;
    }
}

