/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.jkniv.whinstone.types.ColumnType;
import net.sf.jkniv.whinstone.types.ConverterException;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.JdbcType;

public class DateIntType
implements Convertible<Date, Integer> {
    private String pattern;

    public DateIntType(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Integer toJdbc(Date attribute) {
        if (attribute == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
        return Integer.valueOf(sdf.format(attribute));
    }

    @Override
    public Date toAttribute(Integer jdbc) {
        if (jdbc == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
        try {
            return sdf.parse(String.valueOf(jdbc));
        }
        catch (ParseException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    public ColumnType getColumnType() {
        return JdbcType.INTEGER;
    }

    public String toString() {
        return "DateIntType [pattern=" + this.pattern + ", type=" + this.getType() + ", columnType=" + this.getColumnType() + "]";
    }
}

