/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.types;

import net.sf.jkniv.whinstone.types.ColumnType;
import net.sf.jkniv.whinstone.types.ConverterException;
import net.sf.jkniv.whinstone.types.Convertible;
import net.sf.jkniv.whinstone.types.JdbcType;

public class BooleanCharType
implements Convertible<Boolean, String> {
    private String truePattern;
    private String falsePattern;

    public BooleanCharType(String pattern) {
        String[] patterns = pattern.split("\\|");
        if (patterns.length != 2) {
            throw new ConverterException("BooleanCharType expect a separator \"|\" to handle true and false values, for example \"1|0\". The value was: " + pattern);
        }
        this.truePattern = patterns[0];
        this.falsePattern = patterns[1];
    }

    @Override
    public String toJdbc(Boolean attribute) {
        if (attribute == null) {
            return null;
        }
        return attribute != false ? this.truePattern : this.falsePattern;
    }

    @Override
    public Boolean toAttribute(String jdbc) {
        if (jdbc == null) {
            return null;
        }
        return jdbc.equals(this.truePattern) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public ColumnType getColumnType() {
        return JdbcType.CHAR;
    }

    public String toString() {
        return "BooleanCharType [truePattern=" + this.truePattern + ", falsePattern=" + this.falsePattern + ", type=" + this.getType() + ", columnType=" + this.getColumnType() + "]";
    }
}

