/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.transaction;

import java.util.HashMap;
import java.util.Map;
import net.sf.jkniv.whinstone.ConnectionAdapter;
import net.sf.jkniv.whinstone.transaction.TransactionContext;
import net.sf.jkniv.whinstone.transaction.TransactionException;
import net.sf.jkniv.whinstone.transaction.TransactionStatus;
import net.sf.jkniv.whinstone.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSessions {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionSessions.class);
    private static final ThreadLocal<Map<String, TransactionContext>> RESOURCES = new ThreadLocal();

    public static boolean isEmpty(String contextName) {
        return TransactionSessions.get(contextName) == null;
    }

    public static TransactionContext get(String contextName) {
        Map<String, TransactionContext> context = RESOURCES.get();
        if (context == null) {
            return null;
        }
        return context.get(contextName);
    }

    public static TransactionContext set(String contextName, Transactional tx, ConnectionAdapter conn) {
        if (tx == null) {
            throw new TransactionException("Cannot set a null connection to transaction context");
        }
        Map<String, TransactionContext> transactionContext = RESOURCES.get();
        if (transactionContext == null) {
            transactionContext = new HashMap<String, TransactionContext>();
            RESOURCES.set(transactionContext);
        }
        if (transactionContext.isEmpty() || !transactionContext.containsKey(contextName)) {
            transactionContext.put(contextName, new TransactionContext(contextName, tx, conn));
        } else if (transactionContext.containsKey(contextName)) {
            throw new TransactionException("Already exists a connection bound to context name [" + contextName + "] for this thread. jkniv-whinstone-jdbc doesn't support multiple or nested transactions in same Thread!");
        }
        return transactionContext.get(contextName);
    }

    public static void close(String contextName) {
        TransactionContext transactionContext = TransactionSessions.get(contextName);
        TransactionStatus txStatus = transactionContext.getTransactional().getStatus();
        if (txStatus == TransactionStatus.COMMITTED || txStatus == TransactionStatus.ROLLEDBACK) {
            TransactionSessions.releaseResource(contextName);
        } else if (txStatus == TransactionStatus.MARKED_ROLLBACK || txStatus == TransactionStatus.PREPARING) {
            LOG.warn("Be careful transaction was finished with status [{}]", (Object)txStatus);
            TransactionSessions.releaseResource(contextName);
        } else {
            LOG.error("Transaction was closed with status [{}]", (Object)txStatus);
            TransactionSessions.releaseResource(contextName);
        }
    }

    private static void releaseResource(String contextName) {
        try {
            TransactionContext txContext = TransactionSessions.get(contextName);
            txContext.getConnection().close();
            Map<String, TransactionContext> contexts = RESOURCES.get();
            if (contexts.size() == 1) {
                contexts.clear();
                RESOURCES.remove();
            } else {
                contexts.remove(contextName);
            }
        }
        finally {
            RESOURCES.remove();
        }
    }
}

