/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.transaction;

import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.whinstone.ConnectionAdapter;
import net.sf.jkniv.whinstone.transaction.TransactionStatus;
import net.sf.jkniv.whinstone.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContext.class);
    private static final Assertable NOT_NULL = AssertsFactory.getNotNull();
    private final String name;
    private final ConnectionAdapter conn;
    private Transactional tx;

    public TransactionContext() {
        this("Empty", null, null);
    }

    public TransactionContext(String name, Transactional tx, ConnectionAdapter conn) {
        NOT_NULL.verify(new Object[]{name, tx, conn});
        this.name = name;
        this.tx = tx;
        this.conn = conn;
    }

    public boolean isActive() {
        return this.tx.getStatus() == TransactionStatus.ACTIVE;
    }

    public String getName() {
        return this.name;
    }

    public Transactional getTransactional() {
        return this.tx;
    }

    public ConnectionAdapter getConnection() {
        return this.conn;
    }
}

