/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.commands;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.sqlegance.SqlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectCallback.class);
    private static final Assertable NOT_NULL = AssertsFactory.getNotNull();
    static final ObjectCallback EMPTY = new ObjectCallback(String.class);
    private Class<?> targetClass;
    private Map<SqlType, Set<Method>> preMethods;
    private Map<SqlType, Set<Method>> postMethods;
    private Map<SqlType, Method> commitMethod;
    private Map<SqlType, Method> exceptionMethod;

    public ObjectCallback(Class<?> targetClass) {
        NOT_NULL.verify(new Object[]{targetClass});
        this.targetClass = targetClass;
        this.preMethods = new HashMap<SqlType, Set<Method>>();
        this.postMethods = new HashMap<SqlType, Set<Method>>();
        this.commitMethod = new HashMap<SqlType, Method>();
        this.exceptionMethod = new HashMap<SqlType, Method>();
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Set<Method> getPreMethods(SqlType sqlType) {
        Set<Method> methods = this.preMethods.get(sqlType);
        if (methods == null) {
            return ObjectCallback.EMPTY.preMethods.get(sqlType);
        }
        return methods;
    }

    public void addPreMethod(SqlType sqlType, Method m) {
        Set<Method> methods = this.preMethods.get(sqlType);
        if (methods == null) {
            methods = new HashSet<Method>();
            this.preMethods.put(sqlType, methods);
        }
        methods.add(m);
    }

    public Set<Method> getPostMethods(SqlType sqlType) {
        Set<Method> methods = this.postMethods.get(sqlType);
        if (methods == null) {
            return ObjectCallback.EMPTY.postMethods.get(sqlType);
        }
        return methods;
    }

    public void addPostMethod(SqlType sqlType, Method m) {
        Set<Method> methods = this.postMethods.get(sqlType);
        if (methods == null) {
            methods = new HashSet<Method>();
            this.postMethods.put(sqlType, methods);
        }
        methods.add(m);
    }

    public Method getCommitMethod(SqlType sqlType) {
        return this.commitMethod.get(sqlType);
    }

    public void addCommitMethod(SqlType sqlType, Method method) {
        Method m = this.commitMethod.put(sqlType, method);
        if (m != null) {
            LOG.warn("There are more one callback method to [{}] after commit. {} was replaced for {}", new Object[]{sqlType, m, method});
        }
    }

    public Method getExceptionMethod(SqlType sqlType) {
        return this.exceptionMethod.get(sqlType);
    }

    public void addExceptionMethod(SqlType sqlType, Method method) {
        Method m = this.exceptionMethod.put(sqlType, method);
        if (m != null) {
            LOG.warn("There are more one callback method to [{}] after exception. {} was replaced for {}", new Object[]{sqlType, m, method});
        }
    }

    public String toString() {
        return "ObjectCallback [clazz=" + this.targetClass + ", preMethods=" + this.preMethods + ", postMethods=" + this.postMethods + ", commitMethod=" + this.commitMethod + ", rollbackMethod=" + this.exceptionMethod + "]";
    }

    static {
        Set M = Collections.emptySet();
        ObjectCallback.EMPTY.preMethods.put(SqlType.SELECT, M);
        ObjectCallback.EMPTY.preMethods.put(SqlType.INSERT, M);
        ObjectCallback.EMPTY.preMethods.put(SqlType.UPDATE, M);
        ObjectCallback.EMPTY.preMethods.put(SqlType.DELETE, M);
        ObjectCallback.EMPTY.postMethods.put(SqlType.SELECT, M);
        ObjectCallback.EMPTY.postMethods.put(SqlType.INSERT, M);
        ObjectCallback.EMPTY.postMethods.put(SqlType.UPDATE, M);
        ObjectCallback.EMPTY.postMethods.put(SqlType.DELETE, M);
        ObjectCallback.EMPTY.commitMethod.put(SqlType.SELECT, null);
        ObjectCallback.EMPTY.commitMethod.put(SqlType.INSERT, null);
        ObjectCallback.EMPTY.commitMethod.put(SqlType.UPDATE, null);
        ObjectCallback.EMPTY.commitMethod.put(SqlType.DELETE, null);
        ObjectCallback.EMPTY.exceptionMethod.put(SqlType.SELECT, null);
        ObjectCallback.EMPTY.exceptionMethod.put(SqlType.INSERT, null);
        ObjectCallback.EMPTY.exceptionMethod.put(SqlType.UPDATE, null);
        ObjectCallback.EMPTY.exceptionMethod.put(SqlType.DELETE, null);
    }
}

