/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.commands;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.sqlegance.SqlType;
import net.sf.jkniv.whinstone.CallbackScope;
import net.sf.jkniv.whinstone.PostCallBack;
import net.sf.jkniv.whinstone.PreCallBack;
import net.sf.jkniv.whinstone.commands.ObjectCallback;

class CallbackProcessor {
    private ObjectProxy<?> proxyParams;

    public CallbackProcessor(ObjectProxy<?> proxyParams) {
        this.proxyParams = proxyParams;
    }

    public ObjectCallback loadCallbackEvents() {
        ObjectCallback objectCallback = new ObjectCallback(this.proxyParams.getTargetClass());
        List precallbacks = this.proxyParams.getMethodsAnnotatedWith(PreCallBack.class);
        List postcallbacks = this.proxyParams.getMethodsAnnotatedWith(PostCallBack.class);
        for (Method m : precallbacks) {
            PreCallBack precallback = m.getAnnotation(PreCallBack.class);
            for (CallbackScope scope : precallback.scope()) {
                if (scope.isSelect()) {
                    objectCallback.addPreMethod(SqlType.SELECT, m);
                    continue;
                }
                if (scope.isAdd()) {
                    objectCallback.addPreMethod(SqlType.INSERT, m);
                    continue;
                }
                if (scope.isUpdate()) {
                    objectCallback.addPreMethod(SqlType.UPDATE, m);
                    continue;
                }
                if (!scope.isRemove()) continue;
                objectCallback.addPreMethod(SqlType.DELETE, m);
            }
        }
        for (Method m : postcallbacks) {
            PostCallBack postcallback = m.getAnnotation(PostCallBack.class);
            List<CallbackScope> scopes = Arrays.asList(postcallback.scope());
            for (CallbackScope scope : postcallback.scope()) {
                if (scope.isSelect()) {
                    objectCallback.addPostMethod(SqlType.SELECT, m);
                    continue;
                }
                if (scope.isAdd()) {
                    objectCallback.addPostMethod(SqlType.INSERT, m);
                    continue;
                }
                if (scope.isUpdate()) {
                    objectCallback.addPostMethod(SqlType.UPDATE, m);
                    continue;
                }
                if (!scope.isRemove()) continue;
                objectCallback.addPostMethod(SqlType.DELETE, m);
            }
        }
        return objectCallback;
    }
}

