/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone.classification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jkniv.reflect.beans.CapitalNameFactory;
import net.sf.jkniv.reflect.beans.Capitalize;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.reflect.beans.ObjectProxyFactory;
import net.sf.jkniv.whinstone.classification.Groupable;
import net.sf.jkniv.whinstone.classification.MapTransform;
import net.sf.jkniv.whinstone.classification.ObjectTransform;
import net.sf.jkniv.whinstone.classification.Transformable;

public class GroupingBy<T, R>
implements Groupable<T, R> {
    private static final Capitalize CAPITAL_GETTER = CapitalNameFactory.getInstanceOfGetter();
    private final Transformable<R> transform;
    private final Map<String, T> grouped = new LinkedHashMap<String, T>();
    private final List<String> keys;
    private final Class<T> type;

    public GroupingBy(List<String> keys, Class<T> type, Transformable.TransformableType transformableType) {
        this.keys = keys;
        this.type = type;
        this.transform = transformableType == Transformable.TransformableType.MAP ? new MapTransform() : new ObjectTransform();
    }

    public GroupingBy(List<String> keys, Class<T> type, Transformable<R> transform) {
        this.keys = keys;
        this.type = type;
        this.transform = transform;
    }

    @Override
    public void classifier(R row) {
        ObjectProxy rowProxy = ObjectProxyFactory.of(row);
        StringBuilder keySb = new StringBuilder();
        for (String k : this.keys) {
            Object keyValue = null;
            keyValue = row instanceof Map ? (Object)((Map)row).get(k) : rowProxy.invoke(CAPITAL_GETTER.does(k), new Object[0]);
            if (keyValue == null) continue;
            keySb.append(keyValue.toString());
        }
        String key = keySb.toString();
        T object = this.grouped.get(key);
        if (object == null) {
            object = this.transform.transform(row, this.type);
            this.grouped.put(key, object);
        } else {
            this.transform.transform(row, object);
        }
    }

    @Override
    public Collection<T> asCollection() {
        return this.grouped.values();
    }

    @Override
    public List<T> asList() {
        return new ArrayList<T>(this.grouped.values());
    }

    @Override
    public Set<T> asSet() {
        return new HashSet<T>(this.grouped.values());
    }
}

