/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone;

import java.util.HashMap;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.whinstone.QueryName;
import net.sf.jkniv.whinstone.Queryable;
import net.sf.jkniv.whinstone.types.RegisterType;

public class QueryFactory {
    private static final Assertable NOT_NULL = AssertsFactory.getNotNull();

    QueryFactory() {
    }

    public static Queryable of(String name, Object ... args) {
        NOT_NULL.verify(new Object[]{name});
        return QueryFactory.buildQueryable(name, null, args);
    }

    public static Queryable of(String name, RegisterType registerType, Object ... args) {
        NOT_NULL.verify(new Object[]{name, registerType});
        return QueryFactory.buildQueryable(name, registerType, args);
    }

    public static Queryable of(String name, Object params) {
        NOT_NULL.verify(new Object[]{name, params});
        return new QueryName(name, params, 0, Integer.MAX_VALUE);
    }

    public static Queryable ofArray(String name, Object ... params) {
        NOT_NULL.verify(new Object[]{name, params});
        return new QueryName(name, params, 0, Integer.MAX_VALUE);
    }

    public static Queryable ofArray(String name, RegisterType registerType, Object ... params) {
        NOT_NULL.verify(new Object[]{name, registerType, params});
        return new QueryName(name, params, 0, Integer.MAX_VALUE, registerType);
    }

    public static Queryable of(String name, Object params, int offset, int max) {
        NOT_NULL.verify(new Object[]{name, name, params});
        return new QueryName(name, params, offset, max);
    }

    public static Queryable of(String name, int offset, int max) {
        NOT_NULL.verify(new Object[]{name});
        return new QueryName(name, null, offset, max);
    }

    public static <T> Queryable of(String name, Class<T> returnType, Object ... args) {
        NOT_NULL.verify(new Object[]{name, returnType, args});
        QueryName q = (QueryName)QueryFactory.buildQueryable(name, null, args);
        q.setReturnType(returnType);
        return q;
    }

    public static <T> Queryable of(String name, Class<T> returnType, Object params) {
        NOT_NULL.verify(new Object[]{name, returnType, params});
        QueryName q = new QueryName(name, params);
        q.setReturnType(returnType);
        return q;
    }

    public static <T> Queryable of(String name, Class<T> returnType) {
        NOT_NULL.verify(new Object[]{name, returnType});
        QueryName q = new QueryName(name);
        q.setReturnType(returnType);
        return q;
    }

    public static <T> Queryable clone(Queryable queryable) {
        NOT_NULL.verify(new Object[]{queryable});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), queryable.getRegisterType(), null);
    }

    public static <T> Queryable clone(Queryable queryable, Class<T> returnType) {
        NOT_NULL.verify(new Object[]{queryable, returnType});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), queryable.getRegisterType(), returnType);
    }

    public static <T> Queryable clone(Queryable queryable, RegisterType registerType) {
        NOT_NULL.verify(new Object[]{queryable, registerType});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), registerType, null);
    }

    public static <T> Queryable clone(Queryable queryable, RegisterType registerType, Class<T> returnType) {
        NOT_NULL.verify(new Object[]{queryable, registerType});
        return QueryFactory.clone(queryable.getName(), queryable, queryable.getParams(), registerType, returnType);
    }

    public static <T> Queryable clone(String queryName, Queryable queryable, Object params, RegisterType registerType, Class<T> returnType) {
        QueryName q = new QueryName(queryName, params, queryable.getOffset(), queryable.getMax(), registerType);
        if (returnType != null) {
            q.setReturnType(returnType);
        } else if (queryable.hasReturnType()) {
            q.setReturnType(queryable.getReturnType());
        }
        if (queryable.isCacheIgnore()) {
            q.cacheIgnore();
        }
        if (queryable.isScalar()) {
            q.scalar();
        }
        return q;
    }

    private static Queryable buildQueryable(String name, RegisterType registerType, Object ... args) {
        NOT_NULL.verify(args);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object value = null;
        QueryName queryable = null;
        if (args.length == 1) {
            queryable = new QueryName(name, args[0], 0, Integer.MAX_VALUE, registerType);
        } else {
            int i = 0;
            String key = null;
            for (Object o : args) {
                if (i % 2 == 0) {
                    key = o.toString();
                } else {
                    value = o;
                    params.put(key, value);
                    key = null;
                    value = null;
                }
                ++i;
            }
            queryable = i > 1 ? new QueryName(name, params, 0, Integer.MAX_VALUE, registerType) : new QueryName(name, null, 0, Integer.MAX_VALUE, registerType);
        }
        return queryable;
    }
}

