/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.whinstone;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jkniv.whinstone.Param;

class ArrayIterator
implements Iterator<Param> {
    private final Object[] array;
    private int currentIndex = 0;
    private int length;

    public ArrayIterator(Map<String, Object> map) {
        this.array = new Object[map.size()];
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        int i = 0;
        for (Map.Entry<String, Object> entry : entries) {
            this.array[i] = entry.getValue();
        }
        this.length = map.size();
    }

    public ArrayIterator(Collection<?> col) {
        this.array = col.toArray();
        this.length = col.size();
    }

    public ArrayIterator(Object[] array, int length) {
        this.array = array;
        this.length = length;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.length;
    }

    @Override
    public Param next() {
        return new Param(Array.get(this.array, this.currentIndex++), this.currentIndex - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannot remove elements from array");
    }
}

