/* 
 * JKNIV, whinstone one contract to access your database.
 * 
 * Copyright (C) 2017, the original author or authors.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package net.sf.jkniv.whinstone;

import static java.lang.annotation.ElementType.METHOD;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Hook method to be invoked <strong>after</strong> execution of {@link Repository} method.
 * <p>
 * This annotation may be applied to methods of an class or superclass from {@link Queryable} parameters.
 *
 * @author Alisson Gomes
 * @since 0.6.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(METHOD)
public @interface PostCallBack
{
    /**
     * Scope of execution pre-callback methods.
     * @return a set of {@link CallbackScope}, default is NONE.
     */
    CallbackScope[] scope() default CallbackScope.NONE;

}
