/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import net.sf.jkniv.sqlegance.ConstraintException;
import net.sf.jkniv.sqlegance.validation.ValidateType;
import net.sf.jkniv.sqlegance.validation.Validatory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidateImpl
implements Validatory {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateImpl.class);
    private static Validator validator;

    ValidateImpl() {
    }

    @Override
    public void assertValidate(Object params, ValidateType validateType) {
        if (validator == null) {
            return;
        }
        Map<String, String> constraints = this.validate(params, validateType.getValidateGroup());
        if (!constraints.isEmpty()) {
            throw new ConstraintException(constraints);
        }
    }

    @Override
    public <T> void assertValidate(Object params, Class<T> validateGroup) {
        Map<String, String> constraints = this.validate(params, validateGroup);
        if (!constraints.isEmpty()) {
            throw new ConstraintException(constraints);
        }
    }

    @Override
    public Map<String, String> validate(Object params, ValidateType validateType) {
        return this.validate(params, validateType.getValidateGroup());
    }

    @Override
    public <T> Map<String, String> validate(Object params, Class<T> validateGroup) {
        if (validator == null) {
            return Collections.emptyMap();
        }
        Set violations = validator.validate(params, new Class[]{validateGroup});
        HashMap<String, String> constraints = new HashMap<String, String>(violations.size());
        for (ConstraintViolation violation : violations) {
            constraints.put(((Path.Node)violation.getPropertyPath().iterator().next()).getName(), violation.getMessage());
        }
        return constraints;
    }

    static {
        try {
            validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        catch (Exception e) {
            LOG.warn("Implementation for JSR Bean Validation not found! Add validator jar at classpah like hibernate-validator to works.");
        }
    }
}

