/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.params;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.sqlegance.params.AbstractParamParser;
import net.sf.jkniv.sqlegance.params.ParamMarkType;
import net.sf.jkniv.sqlegance.params.ParamParser;

public class ParamParserColonMark
extends AbstractParamParser {
    private static final Pattern PATTERN_PARAMS = Pattern.compile("(:[\\w\\.?]+|:in:[\\w\\.?]+|'[^']*')+", 10);
    private static final ParamParser INSTANCE = new ParamParserColonMark();

    private ParamParserColonMark() {
    }

    public static ParamParser getInstance() {
        return INSTANCE;
    }

    @Override
    Pattern getPatternParams() {
        return PATTERN_PARAMS;
    }

    @Override
    public String[] find(String query) {
        return this.parserColon(query).toArray(new String[0]);
    }

    @Override
    public ParamMarkType getType() {
        return ParamMarkType.COLON;
    }

    private List<String> parserColon(String sentence) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcherTwoDots = PATTERN_PARAMS.matcher(sentence);
        int i = 0;
        while (matcherTwoDots.find()) {
            if (matcherTwoDots.group().startsWith("'")) continue;
            if (matcherTwoDots.group().startsWith(":in:")) {
                params.add(i++, sentence.subSequence(matcherTwoDots.start() + 1, matcherTwoDots.end()).toString());
                continue;
            }
            params.add(i++, sentence.subSequence(matcherTwoDots.start() + 1, matcherTwoDots.end()).toString());
        }
        return params;
    }
}

