/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sf.jkniv.asserts.Assertable;
import net.sf.jkniv.asserts.AssertsFactory;
import net.sf.jkniv.env.EnvPropertyResolver;
import net.sf.jkniv.reflect.beans.ObjectProxy;
import net.sf.jkniv.reflect.beans.ObjectProxyFactory;
import net.sf.jkniv.sqlegance.RepositoryProperty;
import net.sf.jkniv.sqlegance.RepositoryType;
import net.sf.jkniv.sqlegance.Statistical;
import net.sf.jkniv.sqlegance.builder.XmlReader;
import net.sf.jkniv.sqlegance.builder.xml.NoSqlStats;
import net.sf.jkniv.sqlegance.builder.xml.SqlStats;
import net.sf.jkniv.sqlegance.dialect.SqlDialect;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureFactory;
import net.sf.jkniv.sqlegance.dialect.SqlFeatureSupport;
import net.sf.jkniv.sqlegance.logger.DataMasking;
import net.sf.jkniv.sqlegance.logger.SimpleDataMasking;
import net.sf.jkniv.sqlegance.transaction.TransactionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepositoryConfig {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryConfig.class);
    private static String defaultFileConfig = "/repository-config.xml";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TX_TYPE = "transaction-type";
    private static final String XPATH_REPO_NODE = "/repository";
    static final String SCHEMA_XSD = "/net/sf/jkniv/sqlegance/builder/xml/sqlegance-config.xsd";
    static final String XPATH_ROOT_NODE = "repository-config";
    private static final String XPATH_PROPERTY_NODE = "repository-config/repository[@name='%s']/properties/property";
    private static final String XPATH_DESCRIPTION_NODE = "repository-config/repository[@name='%s']/description[1]";
    private static final String XPATH_JNDI_DS_NODE = "repository-config/repository[@name='%s']/jndi-data-source[1]";
    private static final Assertable NOT_NULL = AssertsFactory.getNotNull();
    private String name;
    private String description;
    private String jndiDataSource;
    private TransactionType transactionType;
    private Properties properties;
    private DataMasking masking;
    private RepositoryType repositoryType;
    private SqlDialect sqlDialect;
    private EnvPropertyResolver propertyResolver;

    public RepositoryConfig() {
        this(null, true);
    }

    public RepositoryConfig(String name) {
        this(name, false);
    }

    private RepositoryConfig(String name, boolean defaultRepo) {
        if (!defaultRepo) {
            NOT_NULL.verify(new Object[]{name});
        }
        this.name = name;
        this.properties = new Properties();
        this.propertyResolver = new EnvPropertyResolver();
        this.load();
        this.setDataMasking();
        if (this.transactionType == null) {
            this.transactionType = TransactionType.LOCAL;
        }
        if (this.isEmpty(this.jndiDataSource)) {
            this.jndiDataSource = name;
        }
    }

    private void load() {
        XmlReader xmlReader = new XmlReader(defaultFileConfig);
        if (xmlReader.load()) {
            NodeList nodes = xmlReader.evaluateXpath("repository-config/repository");
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String name = element.getAttribute(ATTR_NAME);
                    if (!this.isEmpty(this.name) && !this.name.equals(name)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Binding Sql Statements context [{}] with Repository config [{}]", (Object)this.name, (Object)name);
                    }
                    this.name = name;
                    this.parseAttributes(element);
                    this.parseDescription(xmlReader);
                    this.parseJndiDataSource(xmlReader);
                    this.parseProperties(xmlReader);
                    break;
                }
            } else if (!this.hasProperties()) {
                LOG.info("repository-config.xml does not found. Using [{}] as jndi datasource.", (Object)this.name);
                this.jndiDataSource = this.name;
            }
        }
        this.defineDialect();
    }

    private void parseAttributes(Element element) {
        this.name = element.getAttribute(ATTR_NAME);
        String txType = element.getAttribute(ATTR_TX_TYPE);
        String type = element.getAttribute("type");
        this.transactionType = TransactionType.get(txType);
        this.repositoryType = RepositoryType.get(type);
    }

    private void parseDescription(XmlReader xmlReader) {
        NodeList nodes = xmlReader.evaluateXpath(String.format(XPATH_DESCRIPTION_NODE, this.name));
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            this.description = xmlReader.getTextFromElement(element);
        }
    }

    private void parseJndiDataSource(XmlReader xmlReader) {
        NodeList nodes = xmlReader.evaluateXpath(String.format(XPATH_JNDI_DS_NODE, this.name));
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                this.jndiDataSource = xmlReader.getTextFromElement(element);
            }
        }
    }

    private void parseProperties(XmlReader xmlReader) {
        NodeList nodesProperties = xmlReader.evaluateXpath(String.format(XPATH_PROPERTY_NODE, this.name));
        if (nodesProperties != null) {
            for (int i = 0; i < nodesProperties.getLength(); ++i) {
                Node nodes = nodesProperties.item(i);
                if (nodes.getNodeType() != 1) continue;
                Element element = (Element)nodes;
                String properName = element.getAttribute(ATTR_NAME);
                String properValue = element.getAttribute(ATTR_VALUE);
                this.properties.put(properName, properValue);
            }
        }
    }

    private void setDataMasking() {
        if (this.masking == null) {
            this.masking = new SimpleDataMasking();
            String className = this.getProperty(RepositoryProperty.DATA_MASKING);
            if (className != null) {
                ObjectProxy proxy = ObjectProxyFactory.of((String)className);
                this.masking = (DataMasking)proxy.newInstance();
            }
        }
    }

    public String getQueryNameStrategy() {
        return this.getProperty(RepositoryProperty.QUERY_NAME_STRATEGY);
    }

    public String getJdbcAdapterFactory() {
        String adpterClassName = this.getProperty(RepositoryProperty.JDBC_ADAPTER_FACTORY);
        return adpterClassName;
    }

    public boolean isShotKeyEnable() {
        return Boolean.valueOf(this.getProperty(RepositoryProperty.SHORT_NAME_ENABLE));
    }

    public boolean isReloadableXmlEnable() {
        return Boolean.valueOf(this.getProperty(RepositoryProperty.RELOADABLE_XML_ENABLE));
    }

    public void add(String key, String value) {
        Properties props = new Properties();
        props.put(key, value);
        this.add(props);
    }

    public void add(Properties props) {
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object old = this.properties.put(entry.getKey().toString(), entry.getValue());
                if (old != null) {
                    LOG.info("The value of key [{}] with original value [{}] was replacement to [{}]", new Object[]{entry.getKey(), old, entry.getValue()});
                }
                if (!RepositoryProperty.SQL_DIALECT.key().equals(entry.getKey().toString())) continue;
                this.defineDialect();
            }
        }
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public DataMasking getDataMasking() {
        return this.masking;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public SqlDialect getSqlDialect() {
        return this.sqlDialect;
    }

    public void setSqlDialect(SqlDialect sqlDialect) {
        this.sqlDialect = sqlDialect;
    }

    public Statistical getStatistical() {
        String enable = this.getProperty(RepositoryProperty.SQL_STATS);
        if ("true".equalsIgnoreCase(enable)) {
            return new SqlStats();
        }
        return NoSqlStats.getInstance();
    }

    public String getJndiDataSource() {
        return this.jndiDataSource;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(RepositoryProperty proper) {
        String value = this.properties.getProperty(proper.key(), proper.defaultValue());
        if (value != null) {
            value = this.propertyResolver.getValue(value);
        }
        return value;
    }

    public String getProperty(String proper, String defaultValue) {
        String value = this.properties.getProperty(proper, defaultValue);
        if (value != null) {
            value = this.propertyResolver.getValue(value);
        }
        return value;
    }

    public String getProperty(String proper) {
        return this.getProperty(proper, null);
    }

    public DataSource lookup() {
        String jndi = this.getJndiDataSource();
        DataSource ds = null;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lookuping JNDI resource with: new InitialContext().lookup(\"{}\") ...", (Object)jndi);
            }
            ds = (DataSource)ctx.lookup(jndi);
        }
        catch (NamingException ne) {
            LOG.error("NamingException, cannot lookup jndi datasource [" + jndi + "]: " + ne.getMessage());
        }
        return ds;
    }

    private boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public RepositoryType getRepositoryType() {
        return this.repositoryType;
    }

    private void defineDialect() {
        String sqlDialectName = this.getProperty(RepositoryProperty.SQL_DIALECT);
        ObjectProxy proxy = ObjectProxyFactory.of((String)sqlDialectName);
        this.sqlDialect = (SqlDialect)proxy.newInstance();
        for (SqlFeatureSupport feature : SqlFeatureSupport.values()) {
            String value = this.getProperty("jkniv.repository.feature." + feature.name().toLowerCase());
            if (value == null) continue;
            boolean supported = Boolean.valueOf(value);
            this.sqlDialect.addFeature(SqlFeatureFactory.newInstance(feature, supported));
        }
        String maxParameters = this.getProperty("jkniv.repository.jdbc.max_parameters");
        if (maxParameters != null) {
            this.sqlDialect.setMaxOfParameters(Integer.valueOf(maxParameters));
        }
    }

    public String toString() {
        return "RepositoryConfig [name=" + this.name + ", sqlDialectName=" + this.getSqlDialect() + ", transactionType=" + (Object)((Object)this.transactionType) + "]";
    }
}

