/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.statement;

import net.sf.jkniv.sqlegance.statement.ColumnParser;

class SimpleColumnParser
implements ColumnParser {
    SimpleColumnParser() {
    }

    @Override
    public String[] extract(String sql) {
        String columsAsStr;
        int selects = 0;
        int froms = 0;
        int openedParenthesis = 0;
        int closedParenthesis = 0;
        int lengthOfParenthesis = 0;
        StringBuilder columns = new StringBuilder();
        StringBuilder evaluating = new StringBuilder();
        String sqlTrim = sql.trim().replaceAll("\n", " ");
        String[] columnsOrAliasName = new String[]{};
        int lastCurrent = 32;
        for (int i = 0; i < sqlTrim.length(); ++i) {
            char current = sqlTrim.charAt(i);
            if (current == '(' || current == ')' || current == ' ') {
                if (current == '(') {
                    ++openedParenthesis;
                } else if (current == ')') {
                    ++closedParenthesis;
                }
                if (lengthOfParenthesis > 0 && openedParenthesis == closedParenthesis) {
                    columns.delete(columns.length() - lengthOfParenthesis, columns.length());
                    lengthOfParenthesis = 0;
                    openedParenthesis = 0;
                    closedParenthesis = 0;
                }
                if ("SELECT".equalsIgnoreCase(evaluating.toString())) {
                    ++selects;
                } else if ("FROM".equalsIgnoreCase(evaluating.toString()) && ++froms == selects) {
                    columns.delete(columns.length() - "from".length(), columns.length());
                    break;
                }
                evaluating = new StringBuilder();
                if (lastCurrent != 32) {
                    columns.append(current);
                }
            } else {
                evaluating.append(current);
                columns.append(current);
            }
            if (openedParenthesis > 0) {
                ++lengthOfParenthesis;
            }
            lastCurrent = current;
        }
        if ((columsAsStr = columns.toString()).indexOf("*") > 0) {
            throw new IllegalArgumentException("Cannot resolve column or alias names from select with asterisk (*)");
        }
        String[] columnsSeparated = columsAsStr.split(",");
        columnsOrAliasName = new String[columnsSeparated.length];
        for (int i = 0; i < columnsSeparated.length; ++i) {
            columnsOrAliasName[i] = this.getColumnNameOrAlias(columnsSeparated[i]);
        }
        return columnsOrAliasName;
    }

    private String getColumnNameOrAlias(String value) {
        StringBuilder columnName = new StringBuilder();
        String valueTrim = value.trim();
        for (int i = valueTrim.length() - 1; i >= 0 && ' ' != valueTrim.charAt(i); --i) {
            columnName.insert(0, valueTrim.charAt(i));
        }
        String name = columnName.toString();
        int dotPosition = name.indexOf(".");
        if (dotPosition > 0) {
            if (name.endsWith("\"")) {
                int quotePosition = name.indexOf("\"");
                if (quotePosition > dotPosition) {
                    name = name.substring(dotPosition + 1);
                }
                name = name.replaceAll("\"", "");
            } else {
                name = name.substring(dotPosition + 1);
            }
        }
        return name;
    }
}

