/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml.dynamic;

import java.util.List;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;

public class SetTag
implements ITextTag {
    public static final String TAG_NAME = "set";
    private List<? extends ITextTag> listIfTag;

    public SetTag(List<? extends ITextTag> listIfTag) {
        this.listIfTag = listIfTag;
    }

    @Override
    public boolean eval(Object rootObjects) {
        boolean evaluation = false;
        for (int i = 0; i < this.listIfTag.size(); ++i) {
            ITextTag tag = this.listIfTag.get(i);
            if (!tag.eval(rootObjects)) continue;
            evaluation = true;
            break;
        }
        return evaluation;
    }

    @Override
    public String getText() {
        throw new IllegalStateException("Conditional tag group cannot getText directly, invoke getText(Object rootObjects)");
    }

    @Override
    public String getText(Object rootObjects) {
        return this.getConditionalText(rootObjects);
    }

    private String getConditionalText(Object rootObjects) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < this.listIfTag.size(); ++i) {
            ITextTag tag = this.listIfTag.get(i);
            if (!tag.eval(rootObjects)) continue;
            String clause = tag.getText().trim();
            if (clause.endsWith(",")) {
                clause = clause.substring(0, clause.length() - 1);
            }
            if (text.indexOf(TAG_NAME) >= 0) {
                text.append(", " + clause);
                continue;
            }
            text.append("set ");
            text.append(clause);
        }
        return text.toString();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean isDynamicGroup() {
        return true;
    }

    @Override
    public List<? extends ITextTag> getTags() {
        return this.listIfTag;
    }
}

