/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.params;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.reflect.BasicType;
import net.sf.jkniv.sqlegance.params.ParamParser;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParamParser
implements ParamParser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String REGEX_SINGLE_QUOTE = "|'[^']*')+";
    protected static final String REGEX_IN = ":in:[\\w\\.?]+";
    protected static final String REGEX_HASH_MARK = "(#\\{[\\w\\.?]+\\}|:in:[\\w\\.?]+|'[^']*')+";
    protected static final String REGEX_COLON_MARK = "(:[\\w\\.?]+|:in:[\\w\\.?]+|'[^']*')+";
    protected static final String REGEX_DOLLAR_MARK = "(\\$[\\w\\.?]+|:in:[\\w\\.?]+|'[^']*')+";
    protected static final String REGEX_QUESTION_MARK = "([\\?]+|:in:[\\w\\.?]+|'[^']*')+";
    private static final Pattern PATTERN_IN = Pattern.compile(":in:[\\w\\.?]+", 10);
    private static final BasicType basicType = BasicType.getInstance();

    abstract Pattern getPatternParams();

    @Override
    public String replaceForPlaceholder(String query) {
        return this.replaceForPlaceholder(query, Collections.emptyList());
    }

    @Override
    public String replaceForPlaceholderWithNumber(String query, Object params) {
        StringBuffer sb = new StringBuffer(query);
        Matcher matcherTwoDots = this.getPatternParams().matcher(query);
        HashMap<String, String> mapForINClauseParams = new HashMap<String, String>();
        int startIndex = 0;
        int endIndex = 0;
        int index = 1;
        while (matcherTwoDots.find()) {
            String match = matcherTwoDots.group();
            if (match.startsWith("'")) continue;
            if (match.startsWith(":in:")) {
                String paramName = match.substring(4, match.length());
                Object[] paramsAsArray = this.getParamsClauseIN(params, paramName);
                if (paramsAsArray == null || paramsAsArray.length <= 0) continue;
                StringBuilder tmp = new StringBuilder();
                for (int i = 0; i < paramsAsArray.length; ++i) {
                    tmp.append(i > 0 ? "," : "").append(this.getPlaceholder() + index++);
                }
                mapForINClauseParams.put(match, tmp.toString());
                continue;
            }
            startIndex = matcherTwoDots.start();
            endIndex = matcherTwoDots.end();
            sb.replace(startIndex, endIndex, this.padspace(endIndex - startIndex, index++));
        }
        if (!mapForINClauseParams.isEmpty()) {
            String newSql = sb.toString();
            for (String key : mapForINClauseParams.keySet()) {
                newSql = newSql.replaceAll(key, (String)mapForINClauseParams.get(key));
            }
            sb = new StringBuffer(newSql);
        }
        return sb.toString();
    }

    @Override
    public String replaceForPlaceholder(String query, Object params) {
        StringBuffer sb = new StringBuffer(query);
        Matcher matcherTwoDots = this.getPatternParams().matcher(query);
        HashMap<String, String> mapForINClauseParams = new HashMap<String, String>();
        int startIndex = 0;
        int endIndex = 0;
        while (matcherTwoDots.find()) {
            String match = matcherTwoDots.group();
            if (match.startsWith("'")) continue;
            if (match.startsWith(":in:")) {
                String paramName = match.substring(4, match.length());
                Object[] paramsAsArray = this.getParamsClauseIN(params, paramName);
                if (paramsAsArray == null || paramsAsArray.length <= 0) continue;
                StringBuilder tmp = new StringBuilder();
                for (int i = 0; i < paramsAsArray.length; ++i) {
                    tmp.append(i > 0 ? "," : "").append(this.getPlaceholder());
                }
                mapForINClauseParams.put(match, tmp.toString());
                continue;
            }
            startIndex = matcherTwoDots.start();
            endIndex = matcherTwoDots.end();
            sb.replace(startIndex, endIndex, this.padspace(endIndex - startIndex, -1));
        }
        if (!mapForINClauseParams.isEmpty()) {
            String newSql = sb.toString();
            for (String key : mapForINClauseParams.keySet()) {
                newSql = newSql.replaceAll(key, (String)mapForINClauseParams.get(key));
            }
            sb = new StringBuffer(newSql);
        }
        return sb.toString();
    }

    @Override
    public String getPlaceholder() {
        return "?";
    }

    protected String padspace(int size, int index) {
        StringBuffer s = new StringBuffer(this.getPlaceholder() + (index < 0 ? "" : Integer.valueOf(index)));
        int newSize = index < 0 ? size : size - String.valueOf(index).length();
        for (int i = 1; i < newSize; ++i) {
            s.append(" ");
        }
        return s.toString();
    }

    protected Object[] getParamsClauseIN(Object params, String name) {
        Object[] paramsClauseIN = this.getParamsAsArray(params);
        if (paramsClauseIN == null) {
            try {
                Object value = PropertyUtils.getProperty((Object)params, (String)name);
                paramsClauseIN = value != null && (value instanceof String || basicType.isNumberType(value.getClass())) ? new Object[]{value} : this.getParamsAsArray(value);
            }
            catch (Exception e) {
                this.log.warn("Cannot read property [{}] for object [{}]. cause={}", new Object[]{name, params == null ? "null" : params.toString(), e.getMessage()});
            }
        }
        return paramsClauseIN;
    }

    private Object[] getParamsAsArray(Object params) {
        Object[] array = null;
        if (params instanceof Collection) {
            array = ((Collection)params).toArray();
        } else if (params != null && params.getClass().isArray()) {
            array = (Object[])params;
        }
        return array;
    }
}

