/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.validation;

import java.util.Map;
import javax.validation.groups.Default;
import net.sf.jkniv.sqlegance.validation.AddValidate;
import net.sf.jkniv.sqlegance.validation.AllValidate;
import net.sf.jkniv.sqlegance.validation.EnrichValidate;
import net.sf.jkniv.sqlegance.validation.GetValidate;
import net.sf.jkniv.sqlegance.validation.ListValidate;
import net.sf.jkniv.sqlegance.validation.NoValidate;
import net.sf.jkniv.sqlegance.validation.RemoveValidate;
import net.sf.jkniv.sqlegance.validation.ScalarValidate;
import net.sf.jkniv.sqlegance.validation.SelectValidate;
import net.sf.jkniv.sqlegance.validation.UpdateValidate;
import net.sf.jkniv.sqlegance.validation.ValidateImpl;
import net.sf.jkniv.sqlegance.validation.Validatory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValidateType {
    NONE{

        @Override
        public Class<?> getValidateGroup() {
            return Default.class;
        }

        @Override
        Validatory getValidatory() {
            return novalidator;
        }
    }
    ,
    ALL{

        @Override
        public Class<?> getValidateGroup() {
            return AllValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    GET{

        @Override
        public Class<?> getValidateGroup() {
            return GetValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    LIST{

        @Override
        public Class<?> getValidateGroup() {
            return ListValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    SELECT{

        @Override
        public Class<?> getValidateGroup() {
            return SelectValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    SCALAR{

        @Override
        public Class<?> getValidateGroup() {
            return ScalarValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    ADD{

        @Override
        public Class<?> getValidateGroup() {
            return AddValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    UPDATE{

        @Override
        public Class<?> getValidateGroup() {
            return UpdateValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    ENRICH{

        @Override
        public Class<?> getValidateGroup() {
            return EnrichValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    }
    ,
    REMOVE{

        @Override
        public Class<?> getValidateGroup() {
            return RemoveValidate.class;
        }

        @Override
        Validatory getValidatory() {
            return validator;
        }
    };

    private static final Validatory novalidator;
    private static Validatory validator;
    private static final Logger LOG;

    static {
        novalidator = new NoValidate();
        LOG = LoggerFactory.getLogger(ValidateType.class);
        try {
            validator = new ValidateImpl();
        }
        catch (Exception e) {
            LOG.warn("Default Bean validator Factory not found, cannot apply validator");
            validator = new NoValidate();
        }
    }

    private ValidateType() {
    }

    public abstract Class<?> getValidateGroup();

    abstract Validatory getValidatory();

    public static ValidateType get(String type) {
        ValidateType validateType = NONE;
        ValidateType[] validateTypeArray = ValidateType.values();
        int n = validateTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidateType t = validateTypeArray[n2];
            if (String.valueOf(type).equalsIgnoreCase(t.name())) {
                validateType = t;
                break;
            }
            ++n2;
        }
        return validateType;
    }

    public void assertValidate(Object params) {
        this.getValidatory().assertValidate(params, this);
    }

    public Map<String, String> validate(Object params) {
        return this.getValidatory().validate(params, this);
    }

    public static void assertValidate(Object params, ValidateType validateType) {
        validator.assertValidate(params, validateType);
    }

    public static <T> void assertValidate(Object params, Class<T> validateGroup) {
        validator.assertValidate(params, validateGroup);
    }

    public static Map<String, String> validate(Object params, ValidateType validateType) {
        return validator.validate(params, validateType);
    }

    public static <T> Map<String, String> validate(Object params, Class<T> validateGroup) {
        return validator.validate(params, validateGroup);
    }

    /* synthetic */ ValidateType(String string, int n, ValidateType validateType) {
        this();
    }
}

