/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import net.sf.jkniv.sqlegance.ConstraintException;
import net.sf.jkniv.sqlegance.validation.ValidateType;
import net.sf.jkniv.sqlegance.validation.ValidationMessage;
import net.sf.jkniv.sqlegance.validation.ValidationMessageImpl;
import net.sf.jkniv.sqlegance.validation.Validatory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidateImpl
implements Validatory {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateImpl.class);
    private static Validator validator;

    static {
        try {
            validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        catch (Exception e) {
            LOG.warn("Implementation for JSR Bean Validation not found! Add validator jar at classpah like hibernate-validator to works.");
        }
    }

    ValidateImpl() {
    }

    @Override
    public void assertValidate(Object params, ValidateType validateType) {
        if (validator == null) {
            return;
        }
        List<ValidationMessage> constraints = this.validateI18n(params, validateType.getValidateGroup());
        if (!constraints.isEmpty()) {
            throw new ConstraintException(constraints);
        }
    }

    @Override
    public <T> void assertValidate(Object params, Class<T> validateGroup) {
        List<ValidationMessage> constraints = this.validateI18n(params, validateGroup);
        if (!constraints.isEmpty()) {
            throw new ConstraintException(constraints);
        }
    }

    @Override
    public Map<String, String> validate(Object params, ValidateType validateType) {
        return this.validate(params, validateType.getValidateGroup());
    }

    @Override
    public <T> Map<String, String> validate(Object params, Class<T> validateGroup) {
        if (validator == null) {
            return Collections.emptyMap();
        }
        Set violations = validator.validate(params, new Class[]{validateGroup});
        HashMap<String, String> constraints = new HashMap<String, String>(violations.size());
        for (ConstraintViolation violation : violations) {
            String name = ((Path.Node)violation.getPropertyPath().iterator().next()).getName();
            if (name == null && violation.getRootBeanClass() != null) {
                name = violation.getRootBeanClass().getSimpleName();
            }
            constraints.put(name, violation.getMessage());
        }
        return constraints;
    }

    @Override
    public List<ValidationMessage> validateI18n(Object params, ValidateType validateType) {
        return this.validateI18n(params, validateType.getValidateGroup());
    }

    @Override
    public <T> List<ValidationMessage> validateI18n(Object params, Class<T> validateGroup) {
        if (validator == null) {
            return Collections.emptyList();
        }
        Set violations = validator.validate(params, new Class[]{validateGroup});
        ArrayList<ValidationMessage> constraints = new ArrayList<ValidationMessage>(violations.size());
        for (ConstraintViolation violation : violations) {
            String field = ((Path.Node)violation.getPropertyPath().iterator().next()).getName();
            String classSimpleName = violation.getRootBeanClass().getSimpleName();
            String qualifiedField = String.valueOf(classSimpleName) + "." + field;
            if (field == null && violation.getRootBeanClass() != null) {
                field = classSimpleName;
                qualifiedField = classSimpleName;
            }
            String key = violation.getMessageTemplate().substring(1, violation.getMessageTemplate().length() - 1);
            constraints.add(ValidationMessageImpl.of(field, qualifiedField, violation.getMessage(), key));
        }
        return constraints;
    }
}

