/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.transaction;

public enum Isolation {
    DEFAULT{

        @Override
        public int level() {
            throw new UnsupportedOperationException("java.sql.Connection haven't this isolation level. Get a valid level.");
        }
    }
    ,
    NONE{

        @Override
        public int level() {
            return 0;
        }
    }
    ,
    READ_UNCOMMITTED{

        @Override
        public int level() {
            return 1;
        }
    }
    ,
    READ_COMMITTED{

        @Override
        public int level() {
            return 2;
        }
    }
    ,
    REPEATABLE_READ{

        @Override
        public int level() {
            return 4;
        }
    }
    ,
    SERIALIZABLE{

        @Override
        public int level() {
            return 8;
        }
    };


    private Isolation() {
    }

    public abstract int level();

    public static Isolation get(int level) {
        Isolation isolation = DEFAULT;
        switch (level) {
            case 0: {
                isolation = NONE;
                break;
            }
            case 2: {
                isolation = READ_COMMITTED;
                break;
            }
            case 1: {
                isolation = READ_UNCOMMITTED;
                break;
            }
            case 4: {
                isolation = REPEATABLE_READ;
                break;
            }
            case 8: {
                isolation = SERIALIZABLE;
            }
        }
        return isolation;
    }

    public static Isolation get(String type) {
        Isolation isolation = DEFAULT;
        Isolation[] isolationArray = Isolation.values();
        int n = isolationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Isolation iso = isolationArray[n2];
            if (String.valueOf(type).equalsIgnoreCase(iso.toString())) {
                isolation = iso;
                break;
            }
            ++n2;
        }
        return isolation;
    }

    /* synthetic */ Isolation(String string, int n, Isolation isolation) {
        this();
    }
}

