/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.params;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.sqlegance.params.AbstractParamParser;
import net.sf.jkniv.sqlegance.params.ParamMarkType;
import net.sf.jkniv.sqlegance.params.ParamParser;

public class ParamParserQuestionMark
extends AbstractParamParser {
    private static final Pattern PATTERN_PARAMS = Pattern.compile("([\\?]+|:in:[\\w\\.?]+|'[^']*')+", 10);
    private static ParamParser INSTANCE = new ParamParserQuestionMark();

    private ParamParserQuestionMark() {
    }

    public static ParamParser getInstance() {
        return INSTANCE;
    }

    @Override
    Pattern getPatternParams() {
        return PATTERN_PARAMS;
    }

    @Override
    public String[] find(String query) {
        return this.parserQuestion(query).toArray(new String[0]);
    }

    @Override
    public ParamMarkType getType() {
        return ParamMarkType.QUESTION;
    }

    private List<String> parserQuestion(String sentence) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcherQuestion = PATTERN_PARAMS.matcher(sentence);
        int i = 0;
        while (matcherQuestion.find()) {
            if (matcherQuestion.group().startsWith("'")) continue;
            if (matcherQuestion.group().startsWith(":in:")) {
                params.add(i++, sentence.subSequence(matcherQuestion.start() + 1, matcherQuestion.end()).toString());
                continue;
            }
            params.add(i++, sentence.subSequence(matcherQuestion.start(), matcherQuestion.end()).toString());
        }
        return params;
    }
}

