/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jkniv.sqlegance.params.AbstractParamParser;
import net.sf.jkniv.sqlegance.params.ParamMarkType;
import net.sf.jkniv.sqlegance.params.ParamParser;

public class ParamParserDollarMark
extends AbstractParamParser {
    private static final Pattern PATTERN_PARAMS = Pattern.compile("(\\$[\\w\\.?]+|:in:[\\w\\.?]+|'[^']*')+", 10);
    private static final ParamParser INSTANCE = new ParamParserDollarMark();

    private ParamParserDollarMark() {
    }

    public static ParamParser getInstance() {
        return INSTANCE;
    }

    @Override
    Pattern getPatternParams() {
        return PATTERN_PARAMS;
    }

    @Override
    public String[] find(String query) {
        return this.parserDollar(query).toArray(new String[0]);
    }

    @Override
    public ParamMarkType getType() {
        return ParamMarkType.DOLLAR;
    }

    @Override
    public String getPlaceholder() {
        return "$";
    }

    private List<String> parserDollar(String sentence) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcherDollar = PATTERN_PARAMS.matcher(sentence);
        int i = 0;
        while (matcherDollar.find()) {
            if (matcherDollar.group().startsWith("'")) continue;
            if (matcherDollar.group().startsWith(":in:")) {
                params.add(i++, sentence.subSequence(matcherDollar.start() + 1, matcherDollar.end()).toString());
                continue;
            }
            params.add(i++, sentence.subSequence(matcherDollar.start() + 1, matcherDollar.end()).toString());
        }
        return params;
    }

    @Override
    public String replaceForPlaceholder(String query, Object params) {
        return this.replaceForPlaceholderWithNumber(query, params);
    }

    @Override
    public String replaceForPlaceholderWithNumber(String query, Object params) {
        StringBuffer sb = new StringBuffer(query);
        Matcher matcherTwoDots = this.getPatternParams().matcher(query);
        HashMap<String, String> mapForINClauseParams = new HashMap<String, String>();
        int startIndex = 0;
        int endIndex = 0;
        int index = 1;
        while (matcherTwoDots.find()) {
            String match = matcherTwoDots.group();
            if (match.startsWith("'")) continue;
            if (match.startsWith(":in:")) {
                String paramName = match.substring(4, match.length());
                Object[] paramsAsArray = this.getParamsClauseIN(params, paramName);
                if (paramsAsArray == null || paramsAsArray.length <= 0 || mapForINClauseParams.containsKey(match)) continue;
                StringBuilder tmp = new StringBuilder();
                int i = 0;
                while (i < paramsAsArray.length) {
                    tmp.append(i > 0 ? "," : "").append("\\" + this.getPlaceholder() + index++);
                    ++i;
                }
                mapForINClauseParams.put(match, tmp.toString());
                continue;
            }
            startIndex = matcherTwoDots.start();
            endIndex = matcherTwoDots.end();
            sb.replace(startIndex, endIndex, this.padspace(endIndex - startIndex, index++));
        }
        if (!mapForINClauseParams.isEmpty()) {
            String newSql = sb.toString();
            for (String key : mapForINClauseParams.keySet()) {
                newSql = newSql.replaceAll(key, (String)mapForINClauseParams.get(key));
            }
            sb = new StringBuffer(newSql);
        }
        return sb.toString();
    }
}

